package techreborn.init.recipes;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import techreborn.api.TechRebornAPI;

import techreborn.init.recipes.RecipeMethods.Type;

/**
 * Created by Prospector
 */
public class RollingMachineRecipes extends RecipeMethods {
	public static void init() {
		register(getMaterial("cupronickel_heating_coil", 3, Type.PART), "NCN", "C C", "NCN", 'N', "ingotNickel", 'C', "ingotCopper");
		register(getMaterial("nichrome_heating_coil", 2, Type.PART), " N ", "NCN", " N ", 'N', "ingotNickel", 'C', "ingotChrome");
		if (oresExist("ingotAluminum")) {
			register(getMaterial("kanthal_heating_coil", 3, Type.PART), "RRR", "CAA", "CCA", 'R', "ingotRefinedIron", 'C', "ingotChrome", 'A', "ingotAluminum");
		}
		if (oresExist("ingotAluminium")) {
			register(getMaterial("kanthal_heating_coil", 3, Type.PART), "RRR", "CAA", "CCA", 'R', "ingotRefinedIron", 'C', "ingotChrome", 'A', "ingotAluminium");
		}
		register(getStack(Blocks.field_150448_aq, 24), "I I", "ISI", "I I", 'I', "ingotIron", 'S', "stickWood");
		register(getStack(Blocks.field_150318_D, 8), "I I", "ISI", "IRI", 'I', "ingotGold", 'S', "stickWood", 'R', "dustRedstone");
		register(getStack(Blocks.field_150319_E, 8), "I I", "IPI", "IRI", 'I', "ingotIron", 'P', getStack(Blocks.field_150456_au), 'R', "dustRedstone");
		register(getStack(Blocks.field_150408_cc, 8), "ISI", "IRI", "ISI", 'I', "ingotIron", 'S', "stickWood", 'R', getStack(Blocks.field_150429_aA));
		register(getStack(Blocks.field_150411_aY, 24), "III", "III", 'I', "ingotIron");
		register(getStack(Items.field_151139_aw, 4), "II ", "II ", "II ", 'I', "ingotIron");
		register(getStack(Items.field_151143_au, 2), "I I", "III", 'I', "ingotIron");
		register(getStack(Items.field_151133_ar, 2), "I I", "I I", " I ", 'I', "ingotIron");
		register(getStack(Blocks.field_150479_bC, 4), " I ", " S ", " W ", 'I', "ingotIron", 'S', "stickWood", 'W', "plankWood");
		register(getStack(Blocks.field_150443_bT, 2), "II ", 'I', "ingotIron");
		register(getStack(Blocks.field_150445_bS, 2), "GG ", 'G', "ingotGold");
	}

	static void register(ItemStack output, Object... componentsObjects) {
		TechRebornAPI.addRollingOreMachinceRecipe(output, componentsObjects);
	}
}
