package techreborn.init.recipes;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import reborncore.api.recipe.RecipeHandler;
import techreborn.api.ScrapboxList;
import techreborn.api.recipe.ScrapboxRecipe;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.DynamicCell;
import techreborn.items.ItemDusts;
import techreborn.items.ItemGems;
import techreborn.items.ItemNuggets;
import techreborn.utils.StackWIPHandler;

import techreborn.init.recipes.RecipeMethods.Type;

/**
 * Created by Prospector
 */
public class ScrapboxRecipes extends RecipeMethods {
	public static void init() {
		register(getStack(Items.field_151045_i));
		register(getStack(Items.field_151055_y));
		register(getStack(Items.field_151044_h));
		register(getStack(Items.field_151034_e));
		register(getStack(Items.field_151168_bH));
		register(getStack(Items.field_151065_br));
		register(getStack(Items.field_151015_O));
		register(getStack(Items.field_151172_bF));
		register(getStack(Items.field_151124_az));
		register(getStack(Items.field_185153_aK));
		register(getStack(Items.field_185151_aI));
		register(getStack(Items.field_185154_aL));
		register(getStack(Items.field_185152_aJ));
		register(getStack(Items.field_185150_aH));
		register(getStack(Items.field_151072_bj));
		register(getStack(Items.field_151111_aL));
		register(getStack(Items.field_151148_bJ));
		register(getStack(Items.field_151026_S));
		register(getStack(Items.field_151031_f));
		register(getStack(Items.field_151077_bg));
		register(getStack(Items.field_151105_aU));
		register(getStack(Items.field_179572_au));
		register(getStack(Items.field_179571_av));
		register(getStack(Items.field_179568_as));
		register(getStack(Items.field_179567_at));
		register(getStack(Items.field_179570_aq));
		register(getStack(Items.field_179569_ar));
		register(getStack(Items.field_151053_p));
		register(getStack(Items.field_151017_I));
		register(getStack(Items.field_151039_o));
		register(getStack(Items.field_151038_n));
		register(getStack(Items.field_151041_m));
		register(getStack(Items.field_151104_aV));
		register(getStack(Items.field_151144_bL, 1, 0));
		register(getStack(Items.field_151144_bL, 1, 2));
		register(getStack(Items.field_151144_bL, 1, 4));
		for (int i = 0; i < StackWIPHandler.devHeads.size(); i++)
			register(StackWIPHandler.devHeads.get(i));
		register(getStack(Items.field_151114_aO));
		register(getStack(Items.field_151007_F));
		register(getStack(Items.field_151143_au));
		register(getStack(Items.field_151108_aI));
		register(getStack(Items.field_151140_bW));
		register(getStack(Items.field_179562_cC));
		register(getStack(Items.field_151097_aZ));
		register(getStack(Items.field_151062_by));
		register(getStack(Items.field_151103_aS));
		register(getStack(Items.field_151054_z));
		register(getStack(Items.field_151118_aC));
		register(getStack(Items.field_151112_aM));
		register(getStack(Items.field_151122_aG));
		register(getStack(Items.field_151121_aF));
		register(getStack(Items.field_151102_aT));
		register(getStack(Items.field_151120_aE));
		register(getStack(Items.field_151070_bp));
		register(getStack(Items.field_151123_aH));
		register(getStack(Items.field_151078_bh));
		register(getStack(Items.field_151155_ap));
		register(getStack(Items.field_151099_bA));
		register(getStack(Items.field_151083_be));
		register(getStack(Items.field_151057_cb));
		register(getStack(Items.field_151141_av));
		register(getStack(Items.field_151137_ax));
		register(getStack(Items.field_151016_H));
		register(getStack(Items.field_179555_bs));
		register(getStack(Items.field_179556_br));
		register(getStack(Items.field_151034_e));
		register(getStack(Items.field_151153_ao));
		register(getStack(Items.field_151074_bl));

		register(DynamicCell.getEmptyCell(1));
		register(getMaterial("water", Type.CELL));
		register(getMaterial("compressedair", Type.CELL));
		register(getMaterial("sap", Type.PART));
		register(getMaterial("rubber", Type.PART));

		register(getStack(Blocks.field_150415_aT));
		register(getStack(Blocks.field_150430_aB));
		register(getStack(Blocks.field_150471_bO));
		register(getStack(Blocks.field_180405_aT));
		register(getStack(Blocks.field_180387_bt));
		register(getStack(Blocks.field_180404_aQ));
		register(getStack(Blocks.field_180392_bq));
		register(getStack(Blocks.field_180406_aS));
		register(getStack(Blocks.field_180385_bs));
		register(getStack(Blocks.field_180403_aR));
		register(getStack(Blocks.field_180386_br));
		register(getStack(Blocks.field_150386_bk));
		register(getStack(Blocks.field_180407_aO));
		register(getStack(Blocks.field_180390_bo));
		register(getStack(Blocks.field_180408_aP));
		register(getStack(Blocks.field_180391_bp));
		register(getStack(Blocks.field_150336_V));
		register(getStack(Blocks.field_150462_ai));
		register(getStack(Blocks.field_150423_aK));
		register(getStack(Blocks.field_150424_aL));
		register(getStack(Blocks.field_150349_c));
		register(getStack(Blocks.field_150346_d, 1, 0));
		register(getStack(Blocks.field_150346_d, 1, 1));
		register(getStack(Blocks.field_150354_m, 1, 0));
		register(getStack(Blocks.field_150354_m, 1, 1));
		register(getStack(Blocks.field_150426_aN));
		register(getStack(Blocks.field_150351_n));
		register(getStack(Blocks.field_150405_ch));
		register(getStack(Blocks.field_150359_w));
		register(getStack(Blocks.field_150410_aZ));
		register(getStack(Blocks.field_150434_aF));
		register(getStack(Blocks.field_150329_H, 1, 0));
		register(getStack(Blocks.field_150329_H, 1, 1));
		register(getStack(Blocks.field_150330_I));
		register(getStack(Blocks.field_150486_ae));
		register(getStack(Blocks.field_150335_W));
		register(getStack(Blocks.field_150448_aq));
		register(getStack(Blocks.field_150319_E));
		register(getStack(Blocks.field_150318_D));
		register(getStack(Blocks.field_150408_cc));
		register(getStack(Blocks.field_150327_N));
		register(getStack(Blocks.field_150328_O, 1, 0));
		register(getStack(Blocks.field_150328_O, 1, 1));
		register(getStack(Blocks.field_150328_O, 1, 2));
		register(getStack(Blocks.field_150328_O, 1, 3));
		register(getStack(Blocks.field_150328_O, 1, 4));
		register(getStack(Blocks.field_150328_O, 1, 5));
		register(getStack(Blocks.field_150328_O, 1, 6));
		register(getStack(Blocks.field_150328_O, 1, 7));
		register(getStack(Blocks.field_150328_O, 1, 8));
		register(getStack(Blocks.field_150338_P));
		register(getStack(Blocks.field_150337_Q));
		register(getStack(Blocks.field_150420_aW));
		register(getStack(Blocks.field_150419_aX));
		register(getStack(Blocks.field_150345_g, 1, 0));
		register(getStack(Blocks.field_150345_g, 1, 1));
		register(getStack(Blocks.field_150345_g, 1, 2));
		register(getStack(Blocks.field_150345_g, 1, 3));
		register(getStack(Blocks.field_150345_g, 1, 4));
		register(getStack(Blocks.field_150345_g, 1, 5));
		register(getStack(Blocks.field_150362_t, 1, 0));
		register(getStack(Blocks.field_150362_t, 1, 1));
		register(getStack(Blocks.field_150362_t, 1, 2));
		register(getStack(Blocks.field_150362_t, 1, 3));
		register(getStack(Blocks.field_150361_u, 1, 0));
		register(getStack(Blocks.field_150361_u, 1, 1));

		register(getStack(ModBlocks.RUBBER_SAPLING));

		for (String i : ItemDusts.types) {
			if (!i.equals(ModItems.META_PLACEHOLDER)) {
				register(ItemDusts.getDustByName(i));
			}
		}

		for (String i : ItemNuggets.types) {
			if (!i.equals(ModItems.META_PLACEHOLDER)) {
				register(ItemNuggets.getNuggetByName(i));
			}
		}

		for (String i : ItemGems.types) {
			if (!i.equals(ModItems.META_PLACEHOLDER)) {
				register(ItemGems.getGemByName(i));
			}
		}

		registerDyable(Items.field_151100_aR);
		registerDyable(Blocks.field_150325_L);
		registerDyable(Blocks.field_150404_cg);
		registerDyable(Blocks.field_150399_cn);
		registerDyable(Blocks.field_150397_co);
		registerDyable(Blocks.field_150406_ce);

		for (int i = 0; i < ScrapboxList.stacks.size(); i++) {
			RecipeHandler.addRecipe(new ScrapboxRecipe(ScrapboxList.stacks.get(i)));
		}
	}

	static void register(ItemStack stack) {
		ScrapboxList.stacks.add(stack);
	}

	static void registerDyable(Item item) {
		for (int i = 0; i < 16; i++)
			register(getStack(item, 1, i));
	}

	static void registerDyable(Block block) {
		registerDyable(Item.func_150898_a(block));
	}
}
