package techreborn.itemblocks;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileAesu;

import java.util.List;

public class ItemBlockAesu extends ItemBlock {

	public ItemBlockAesu(Block p_i45328_1_) {
		super(p_i45328_1_);
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	@SideOnly(Side.CLIENT)
	public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
		if (stack != null && stack.func_77942_o()) {
			if (stack.func_77978_p().func_74775_l("tileEntity") != null)
				list.add(PowerSystem
					.getLocaliszedPower(stack.func_77978_p().func_74775_l("tileEntity").func_74762_e("energy")));
		}
	}

	@Override
	public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side,
	                            float hitX, float hitY, float hitZ, IBlockState newState) {
		if (!world.func_175656_a(pos, newState)) {
			return false;
		}
		if (world.func_180495_p(pos).func_177230_c() == field_150939_a) {
			world.func_180495_p(pos).func_177230_c().func_180633_a(world, pos, newState, player, stack);
			// world.getBlockState(pos).getBlock().onPostBlockPlaced(world, x,
			// y, z, metadata);
		}
		if (stack != null && stack.func_77942_o()) {
			((TileAesu) world.func_175625_s(pos))
				.readFromNBTWithoutCoords(stack.func_77978_p().func_74775_l("tileEntity"));
		}
		return true;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@SideOnly(Side.CLIENT)
	public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
		itemList.add(getDropWithNBT(0));
		itemList.add(getDropWithNBT(1000000000));
	}

	public ItemStack getDropWithNBT(double energy) {
		NBTTagCompound tileEntity = new NBTTagCompound();
		ItemStack dropStack = new ItemStack(ModBlocks.ADJUSTABLE_SU, 1);
		writeToNBTWithoutCoords(tileEntity, energy);
		dropStack.func_77982_d(new NBTTagCompound());
		dropStack.func_77978_p().func_74782_a("tileEntity", tileEntity);
		return dropStack;
	}

	public void writeToNBTWithoutCoords(NBTTagCompound tagCompound, double energy) {
		NBTTagCompound data = new NBTTagCompound();
		data.func_74780_a("energy", energy);
		tagCompound.func_74782_a("TilePowerAcceptor", data);
		tagCompound.func_74780_a("energy", energy);
		tagCompound.func_74780_a("euChange", 0);
		tagCompound.func_74780_a("euLastTick", 0);
		tagCompound.func_74757_a("active", false);
	}
}
