package techreborn.items;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.*;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.client.hud.StackInfoElement;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.Color;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.lib.MessageIDs;

import javax.annotation.Nullable;
import java.util.List;

public class ItemFrequencyTransmitter extends ItemTRNoDestroy {

	public ItemFrequencyTransmitter() {
		func_77655_b("techreborn.frequencyTransmitter");
		func_77637_a(TechRebornCreativeTabMisc.instance);
		func_77625_d(1);
		this.func_185043_a(new ResourceLocation("techreborn:coords"), new IItemPropertyGetter() {
			@SideOnly(Side.CLIENT)
			public float func_185085_a(ItemStack stack,
			                   @Nullable
				                   World worldIn,
			                   @Nullable
				                   EntityLivingBase entityIn) {
				if (stack != null && stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("x") && stack.func_77978_p().func_74764_b("y") && stack.func_77978_p().func_74764_b("z") && stack.func_77978_p().func_74764_b("dim")) {
					return 1.0F;
				}
				return 0.0F;
			}
		});
	}

	@Override
	public EnumActionResult func_180614_a(ItemStack stack,EntityPlayer player, World world, BlockPos pos,
	                                  EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		stack.func_77982_d(new NBTTagCompound());
		stack.func_77978_p().func_74768_a("x", pos.func_177958_n());
		stack.func_77978_p().func_74768_a("y", pos.func_177956_o());
		stack.func_77978_p().func_74768_a("z", pos.func_177952_p());
		stack.func_77978_p().func_74768_a("dim", world.field_73011_w.getDimension());

		if (!world.field_72995_K && ConfigTechReborn.FreqTransmitterChat) {
			ChatUtils.sendNoSpamMessages(MessageIDs.freqTransmitterID, new TextComponentString(
				TextFormatting.GRAY + I18n.func_74838_a("techreborn.message.setTo") + " X: " +
					TextFormatting.GOLD + pos.func_177958_n() +
					TextFormatting.GRAY + " Y: " +
					TextFormatting.GOLD + pos.func_177956_o() +
					TextFormatting.GRAY + " Z: " +
					TextFormatting.GOLD + pos.func_177952_p() +
					TextFormatting.GRAY + " " + I18n.func_74838_a("techreborn.message.in") + " " +
					TextFormatting.GOLD + DimensionManager.getProviderType(world.field_73011_w.getDimension())
					.func_186065_b() + " (" + world.field_73011_w.getDimension() + ")"));
		}
		return EnumActionResult.SUCCESS;
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(ItemStack stack,World world, EntityPlayer player,
	                                                EnumHand hand) {
		if (player.func_70093_af()) {
			stack.func_77982_d(null);
			if (!world.field_72995_K && ConfigTechReborn.FreqTransmitterChat) {
				ChatUtils.sendNoSpamMessages(MessageIDs.freqTransmitterID, new TextComponentString(
					TextFormatting.GRAY + I18n.func_74838_a("techreborn.message.coordsHaveBeen") + " "
						+ TextFormatting.GOLD + I18n.func_74838_a("techreborn.message.cleared")));
			}
		}

		return new ActionResult<>(EnumActionResult.SUCCESS, stack);
	}

	public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
		if (ConfigTechReborn.FreqTransmitterTooltip) {
			if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("x") && stack.func_77978_p().func_74764_b("y") && stack.func_77978_p().func_74764_b("z") && stack.func_77978_p().func_74764_b("dim")) {
				int x = stack.func_77978_p().func_74762_e("x");
				int y = stack.func_77978_p().func_74762_e("y");
				int z = stack.func_77978_p().func_74762_e("z");
				int dim = stack.func_77978_p().func_74762_e("dim");

				list.add(TextFormatting.GRAY + "X: " + TextFormatting.GOLD + x);
				list.add(TextFormatting.GRAY + "Y: " + TextFormatting.GOLD + y);
				list.add(TextFormatting.GRAY + "Z: " + TextFormatting.GOLD + z);
				list.add(TextFormatting.DARK_GRAY + DimensionManager.getProviderType(dim).func_186065_b());

			} else {
				list.add(TextFormatting.GRAY + I18n.func_74838_a("techreborn.message.noCoordsSet"));
			}
		}
	}

	public static class StackInfoFreqTransmitter extends StackInfoElement {
		public StackInfoFreqTransmitter() {
			super(ModItems.FREQUENCY_TRANSMITTER);
		}

		@Override
		public String getText(ItemStack stack) {
			String text = "";
			Color gold = Color.GOLD;
			Color grey = Color.GRAY;
			if (stack.func_77973_b() instanceof ItemFrequencyTransmitter) {
				if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("x") && stack.func_77978_p().func_74764_b("y") && stack.func_77978_p().func_74764_b("z") && stack.func_77978_p().func_74764_b("dim")) {
					int coordX = stack.func_77978_p().func_74762_e("x");
					int coordY = stack.func_77978_p().func_74762_e("y");
					int coordZ = stack.func_77978_p().func_74762_e("z");
					int coordDim = stack.func_77978_p().func_74762_e("dim");
					text = grey + "X: " + gold + coordX + grey + " Y: " + gold + coordY + grey + " Z: " + gold + coordZ + grey + " Dim: " + gold + DimensionManager.getProviderType(coordDim).func_186065_b() + " (" + coordDim + ")";
				} else {
					text = grey + I18n.func_74838_a("techreborn.message.noCoordsSet");
				}
			}
			return text;
		}
	}
}
