package techreborn.items;

import com.google.common.base.CaseFormat;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import java.util.List;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.init.ModItems;

import java.security.InvalidParameterException;

public class ItemNuggets extends ItemTRNoDestroy {

	public static final String[] types = new String[] { "aluminum", "brass", "bronze", "chrome", "copper", "electrum",
		"invar", "iridium", "lead", "nickel", "platinum", "silver", "steel", "tin", "titanium", "tungsten",
		"hot_tungstensteel", "tungstensteel", "zinc", "refined_iron", ModItems.META_PLACEHOLDER, ModItems.META_PLACEHOLDER,
		ModItems.META_PLACEHOLDER, "iron", "diamond" };

	public ItemNuggets() {
		func_77637_a(TechRebornCreativeTabMisc.instance);
		func_77627_a(true);
		func_77655_b("techreborn.nuggets");
	}

	public static ItemStack getNuggetByName(String name, int count) {
		name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
		for (int i = 0; i < types.length; i++) {
			if (types[i].equalsIgnoreCase(name)) {
				return new ItemStack(ModItems.NUGGETS, count, i);
			}
		}
		throw new InvalidParameterException("The nugget " + name + " could not be found.");
	}

	public static ItemStack getNuggetByName(String name) {
		return getNuggetByName(name, 1);
	}

	@Override
	// gets Unlocalized Name depending on meta data
	public String func_77667_c(ItemStack itemStack) {
		int meta = itemStack.func_77952_i();
		if (meta < 0 || meta >= types.length) {
			meta = 0;
		}

		return super.func_77658_a() + "." + types[meta];
	}

	// Adds Dusts SubItems To Creative Tab
	@Override
	public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
		for (int meta = 0; meta < types.length; ++meta) {
			if (!types[meta].equals(ModItems.META_PLACEHOLDER)) {
				list.add(new ItemStack(item, 1, meta));
			}
		}
	}

}
