package techreborn.items.tools;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.RebornCore;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItem;
import techreborn.client.TechRebornCreativeTab;
import techreborn.utils.OreDictUtils;

import java.util.List;
import java.util.Random;

import net.minecraft.item.Item.ToolMaterial;

public class ItemJackhammer extends ItemPickaxe implements IEnergyItemInfo {

	public static int tier = 1;
	public int maxCharge = 1;
	public int cost = 250;
	public double transferLimit = 100;

	public ItemJackhammer(ToolMaterial material, String unlocalizedName, int energyCapacity, int tier) {
		super(material);
		field_77864_a = 20F;
		func_77637_a(TechRebornCreativeTab.instance);
		func_77625_d(1);
		func_77656_e(240);
		func_77655_b(unlocalizedName);
		this.maxCharge = energyCapacity;
		this.tier = tier;
	}

	@Override
	public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos,
	                                EntityLivingBase entityLiving) {
		Random rand = new Random();
		if (rand.nextInt(EnchantmentHelper.func_77506_a(Enchantments.field_185307_s, stack) + 1) == 0) {
			PoweredItem.useEnergy(cost, stack);
		}
		return true;
	}

	@Override
	public boolean func_150897_b(IBlockState state) {
		// TODO needs // FIXME: 13/03/2016
		return OreDictUtils.isOre(state, "stone") || state.func_177230_c().func_149688_o(state) == Material.field_151576_e && PoweredItem.canUseEnergy(cost, null);
	}

	@Override
	public float func_150893_a(ItemStack stack, IBlockState state) {
		if ((OreDictUtils.isOre(state, "stone") || state.func_177230_c() == Blocks.field_150348_b) && PoweredItem.canUseEnergy(cost, stack)) {
			return field_77864_a;
		} else {
			return 0.5F;
		}
	}

	@Override
	public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
		return true;
	}

	@Override
	public boolean isRepairable() {
		return false;
	}

	@Override
	public double getMaxPower(ItemStack stack) {
		return maxCharge;
	}

	@Override
	public boolean canAcceptEnergy(ItemStack stack) {
		return true;
	}

	@Override
	public boolean canProvideEnergy(ItemStack stack) {
		return false;
	}

	@Override
	public double getMaxTransfer(ItemStack stack) {
		return transferLimit;
	}

	@Override
	public int getStackTier(ItemStack stack) {
		return tier;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@SideOnly(Side.CLIENT)
	public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
		ItemStack itemStack = new ItemStack(this, 1);
		itemList.add(itemStack);

		ItemStack charged = new ItemStack(this, 1);
		PoweredItem.setEnergy(getMaxPower(charged), charged);
		itemList.add(charged);
	}

	@Override
	public double getDurabilityForDisplay(ItemStack stack) {
		if (PoweredItem.getEnergy(stack) > getMaxPower(stack)) {
			return 0;
		}
		double charge = (PoweredItem.getEnergy(stack) / getMaxPower(stack));
		return 1 - charge;

	}

	@Override
	public boolean showDurabilityBar(ItemStack stack) {
		return true;
	}
}
