package techreborn.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.*;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItem;
import reborncore.common.util.ChatUtils;
import techreborn.client.TechRebornCreativeTab;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.lib.MessageIDs;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.item.Item.ToolMaterial;

public class ItemNanosaber extends ItemSword implements IEnergyItemInfo {
	public int cost = 250;

	public ItemNanosaber() {
		super(ToolMaterial.DIAMOND);
		setNoRepair();
		func_77637_a(TechRebornCreativeTab.instance);
		func_77625_d(1);
		func_77655_b("techreborn.nanosaber");
		this.func_185043_a(new ResourceLocation("techreborn:active"), new IItemPropertyGetter() {
			@SideOnly(Side.CLIENT)
			public float func_185085_a(ItemStack stack,
			                   @Nullable
				                   World worldIn,
			                   @Nullable
				                   EntityLivingBase entityIn) {
				if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("isActive") && stack.func_77978_p().func_74767_n("isActive")) {
					if (PoweredItem.getMaxPower(stack) - PoweredItem.getEnergy(stack) >= 0.9 * PoweredItem.getMaxPower(stack))
						return 0.5F;
					return 1.0F;
				}
				return 0.0F;
			}
		});
	}

	@Override
	public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot,
	                                                                 ItemStack stack) {
		Multimap<String, AttributeModifier> multimap = HashMultimap.<String, AttributeModifier>create();
		int modifier = 0;
		if (stack != null && stack.func_77978_p().func_74767_n("isActive"))
			modifier = 9;

		if (slot == EntityEquipmentSlot.MAINHAND) {
			multimap.put(SharedMonsterAttributes.field_111264_e.func_111108_a(),
				new AttributeModifier(field_111210_e, "Weapon modifier", (double) modifier, 0));
			multimap.put(SharedMonsterAttributes.field_188790_f.func_111108_a(),
				new AttributeModifier(field_185050_h, "Weapon modifier", -2.4000000953674316D, 0));
		}
		return multimap;
	}

	@Override
	public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving,
	                         EntityLivingBase entityliving1) {
		if (PoweredItem.canUseEnergy(cost, itemstack)) {
			PoweredItem.useEnergy(cost, itemstack);
			return true;
		} else {
			return false;
		}
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@SideOnly(Side.CLIENT)
	public void func_150895_a(Item item,
	                        CreativeTabs par2CreativeTabs, List itemList) {
		ItemStack inactiveUncharged = new ItemStack(ModItems.NANOSABER);
		inactiveUncharged.func_77982_d(new NBTTagCompound());
		inactiveUncharged.func_77978_p().func_74757_a("isActive", false);

		ItemStack inactiveCharged = new ItemStack(ModItems.NANOSABER);
		inactiveCharged.func_77982_d(new NBTTagCompound());
		inactiveCharged.func_77978_p().func_74757_a("isActive", false);
		PoweredItem.setEnergy(getMaxPower(inactiveCharged), inactiveCharged);

		ItemStack activeCharged = new ItemStack(ModItems.NANOSABER);
		activeCharged.func_77982_d(new NBTTagCompound());
		activeCharged.func_77978_p().func_74757_a("isActive", true);
		PoweredItem.setEnergy(getMaxPower(activeCharged), activeCharged);

		itemList.add(inactiveUncharged);
		itemList.add(inactiveCharged);
		itemList.add(activeCharged);
	}

	public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
		if (stack.func_77978_p() == null || !stack.func_77978_p().func_74767_n("isActive")) {
			list.add(TextFormatting.GRAY + I18n.func_74838_a("techreborn.message.nanosaberInactive"));
		} else {
			list.add(TextFormatting.GRAY + I18n.func_74838_a("techreborn.message.nanosaberActive"));
		}
	}

	@Override
	public boolean showDurabilityBar(ItemStack stack) {
		return true;
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player,
	                                                EnumHand hand) {
		if (player.func_70093_af()) {
			if (!PoweredItem.canUseEnergy(cost, stack)) {
				ChatUtils.sendNoSpamMessages(MessageIDs.nanosaberID, new TextComponentString(
					TextFormatting.GRAY + I18n.func_74838_a("techreborn.message.nanosaberEnergyErrorTo") + " "
						+ TextFormatting.GOLD + I18n
						.func_74838_a("techreborn.message.nanosaberActivate")));
			} else {
				if (stack.func_77978_p() == null || !stack.func_77978_p().func_74767_n("isActive")) {
					if (stack.func_77978_p() == null) {
						stack.func_77982_d(new NBTTagCompound());
					}
					stack.func_77978_p().func_74757_a("isActive", true);
					if (!world.field_72995_K && ConfigTechReborn.NanosaberChat) {
						ChatUtils.sendNoSpamMessages(MessageIDs.nanosaberID, new TextComponentString(
							TextFormatting.GRAY + I18n.func_74838_a("techreborn.message.setTo") + " "
								+ TextFormatting.GOLD + I18n
								.func_74838_a("techreborn.message.nanosaberActive")));
					}
				} else {
					stack.func_77978_p().func_74757_a("isActive", false);
					if (!world.field_72995_K && ConfigTechReborn.NanosaberChat) {
						ChatUtils.sendNoSpamMessages(MessageIDs.nanosaberID, new TextComponentString(
							TextFormatting.GRAY + I18n.func_74838_a("techreborn.message.setTo") + " "
								+ TextFormatting.GOLD + I18n
								.func_74838_a("techreborn.message.nanosaberInactive")));
					}
				}
			}
			return new ActionResult<>(EnumActionResult.SUCCESS, stack);
		}
		return new ActionResult<>(EnumActionResult.PASS, stack);
	}

	@Override
	public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
		if (stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("isActive") && !PoweredItem.canUseEnergy(cost, stack)) {
			ChatUtils.sendNoSpamMessages(MessageIDs.nanosaberID, new TextComponentString(
				TextFormatting.GRAY + I18n.func_74838_a("techreborn.message.nanosaberEnergyError") + " "
					+ TextFormatting.GOLD + I18n
					.func_74838_a("techreborn.message.nanosaberDeactivating")));
			stack.func_77978_p().func_74757_a("isActive", false);
		}
	}

	@Override
	public double getDurabilityForDisplay(ItemStack stack) {
		if (PoweredItem.getEnergy(stack) > getMaxPower(stack)) {
			return 0;
		}
		double charge = (PoweredItem.getEnergy(stack) / getMaxPower(stack));
		return 1 - charge;

	}

	@Override
	public boolean isRepairable() {
		return false;
	}

	@Override
	public double getMaxPower(ItemStack stack) {
		return 100000;
	}

	@Override
	public boolean canAcceptEnergy(ItemStack stack) {
		return true;
	}

	@Override
	public boolean canProvideEnergy(ItemStack stack) {
		return false;
	}

	@Override
	public double getMaxTransfer(ItemStack stack) {
		return 512;
	}

	@Override
	public int getStackTier(ItemStack stack) {
		return 2;
	}
}
