package techreborn.items.tools;

import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItem;
import techreborn.client.TechRebornCreativeTab;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;

import javax.annotation.Nullable;
import java.util.Random;

import net.minecraft.item.Item.ToolMaterial;

public class ItemRockCutter extends ItemPickaxe implements IEnergyItemInfo {

	public static final int maxCharge = ConfigTechReborn.RockCutterCharge;
	public static final int tier = ConfigTechReborn.RockCutterTier;
	public int cost = 500;

	public ItemRockCutter() {
		super(ToolMaterial.DIAMOND);
		func_77655_b("techreborn.rockcutter");
		func_77637_a(TechRebornCreativeTab.instance);
		func_77625_d(1);
		field_77864_a = 16F;
	}

	@Override
	public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos,
	                                EntityLivingBase entityLiving) {
		Random rand = new Random();
		if (rand.nextInt(EnchantmentHelper.func_77506_a(Enchantments.field_185307_s, stack) + 1) == 0) {
			PoweredItem.useEnergy(cost, stack);
		}
		return true;
	}

	@Override
	public boolean func_150897_b(IBlockState state) {
		if (Items.field_151046_w.func_150897_b(state)) {
			return true;
		}
		return false;
	}

	@Override
	public int getHarvestLevel(ItemStack stack,
	                           String toolClass,
	                           @Nullable
		                           EntityPlayer player,
	                           @Nullable
		                           IBlockState blockState) {
		if (!stack.func_77948_v()) {
			stack.func_77966_a(Enchantment.func_185262_c(33), 1);
		}
		return super.getHarvestLevel(stack, toolClass, player, blockState);
	}

	@Override
	public float func_150893_a(ItemStack stack, IBlockState state) {
		if (!PoweredItem.canUseEnergy(cost, stack)) {
			return 2F;
		} else {
			return Items.field_151046_w.func_150893_a(stack, state);
		}
	}

	@Override
	public boolean isRepairable() {
		return false;
	}

	@Override
	public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
		stack.func_77966_a(Enchantments.field_185306_r, 1);
	}

	@Override
	public double getMaxPower(ItemStack stack) {
		return maxCharge;
	}

	@Override
	public boolean canAcceptEnergy(ItemStack stack) {
		return true;
	}

	@Override
	public boolean canProvideEnergy(ItemStack stack) {
		return false;
	}

	@Override
	public double getMaxTransfer(ItemStack stack) {
		return 200;
	}

	@Override
	public int getStackTier(ItemStack stack) {
		return 2;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@SideOnly(Side.CLIENT)
	public void func_150895_a(Item item,
	                        CreativeTabs par2CreativeTabs, List itemList) {
		ItemStack uncharged = new ItemStack(ModItems.ROCK_CUTTER);
		ItemStack charged = new ItemStack(ModItems.ROCK_CUTTER);
		PoweredItem.setEnergy(getMaxPower(charged), charged);

		itemList.add(uncharged);
		itemList.add(charged);
	}

	@Override
	public double getDurabilityForDisplay(ItemStack stack) {
		double charge = (PoweredItem.getEnergy(stack) / getMaxPower(stack));
		return 1 - charge;

	}

	@Override
	public boolean showDurabilityBar(ItemStack stack) {
		return true;
	}

}
