package techreborn.items.tools;

import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import reborncore.common.IWrenchable;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.RebornPermissions;
import techreborn.blocks.fluid.BlockFluidBase;
import techreborn.blocks.storage.BlockEnergyStorage;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.compat.CompatManager;
import techreborn.init.ModSounds;
import techreborn.items.ItemTRNoDestroy;
import techreborn.utils.IC2WrenchHelper;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/**
 * Created by modmuss50 on 26/02/2016.
 */
public class ItemWrench extends ItemTRNoDestroy {

	public ItemWrench() {
		func_77637_a(TechRebornCreativeTabMisc.instance);
		func_77655_b("techreborn.wrench");
		func_77625_d(1);
	}

	@Override
	public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos,
	                                       EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
		if (!PermissionAPI.hasPermission(player.func_146103_bH(), RebornPermissions.WRENCH_BLOCK, new BlockPosContext(player, pos, world.func_180495_p(pos), side))) {
			return EnumActionResult.FAIL;
		}
		if (CompatManager.isIC2Loaded) {
			EnumActionResult result = IC2WrenchHelper.onItemUseFirst(player.func_184586_b(hand), player, world, pos, side, hitX, hitY, hitZ, hand);
			if (result == EnumActionResult.SUCCESS) {
				return result;
			}
		}
		if (world.func_175623_d(pos)) {
			return EnumActionResult.FAIL;
		}
		TileEntity tile = world.func_175625_s(pos);
		if (tile == null) {
			return EnumActionResult.FAIL;
		}

		if (!player.func_70093_af()) {
			if (tile instanceof TileMachineBase) {
				if (side != EnumFacing.DOWN && side != EnumFacing.UP) {
					((TileMachineBase) tile).setFacing(side);
					return EnumActionResult.SUCCESS;
				}
			}
			IBlockState state = world.func_180495_p(pos);
			if (state.func_177230_c() instanceof BlockEnergyStorage) {
				EnumFacing facing = state.func_177229_b(BlockEnergyStorage.FACING);
				if (facing.func_176734_d() == side) {
					facing = side;
				} else {
					facing = side.func_176734_d();
				}
				world.func_175656_a(pos, state.func_177226_a(BlockEnergyStorage.FACING, facing));
				return EnumActionResult.SUCCESS;
			}
		}
		return super.onItemUseFirst(stack, player, world, pos, side, hitX, hitY, hitZ, hand);
	}

	@Override
	public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos,
	                                  EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		if (!PermissionAPI.hasPermission(player.func_146103_bH(), RebornPermissions.WRENCH_BLOCK, new BlockPosContext(player, pos, world.func_180495_p(pos), facing))) {
			return EnumActionResult.FAIL;
		}
		if (CompatManager.isIC2Loaded) {
			EnumActionResult result = IC2WrenchHelper.onItemUse(player.func_184586_b(hand), player, world, pos, hand, facing, hitX, hitY, hitZ);
			if (result == EnumActionResult.SUCCESS) {
				return result;
			}
		}
		if (world.func_175623_d(pos)) {
			return EnumActionResult.FAIL;
		}
		TileEntity tile = world.func_175625_s(pos);
		if (tile == null) {
			return EnumActionResult.FAIL;
		}
		if (!world.field_72995_K) {
			if (player.func_70093_af()) {
				List<ItemStack> items = new ArrayList<>();
				if (tile instanceof IInventory) {
					IInventory inventory = (IInventory) tile;
					for (int i = 0; i < inventory.func_70302_i_(); i++) {
						ItemStack itemStack = inventory.func_70301_a(i);

						if (itemStack != null) {
							if (itemStack.field_77994_a > 0) {
								if (itemStack.func_77973_b() instanceof ItemBlock)

									if (!(((ItemBlock) itemStack.func_77973_b()).field_150939_a instanceof BlockFluidBase) || !(((ItemBlock) itemStack.func_77973_b()).field_150939_a instanceof BlockStaticLiquid)
										|| !(((ItemBlock) itemStack.func_77973_b()).field_150939_a instanceof BlockDynamicLiquid)) {
										items.add(itemStack.func_77946_l());
									}
							}
						}
					}
					if (tile instanceof IWrenchable) {
						if (((IWrenchable) tile).wrenchCanRemove(player)) {
							ItemStack itemStack = ((IWrenchable) tile).getWrenchDrop(player);
							if (itemStack == null) {
								return EnumActionResult.FAIL;
							}
							items.add(itemStack);
						}
						if (!items.isEmpty()) {
							for (ItemStack itemStack : items) {

								Random rand = new Random();

								float dX = rand.nextFloat() * 0.8F + 0.1F;
								float dY = rand.nextFloat() * 0.8F + 0.1F;
								float dZ = rand.nextFloat() * 0.8F + 0.1F;

								EntityItem entityItem = new EntityItem(world, pos.func_177958_n() + dX, pos.func_177956_o() + dY,
									pos.func_177952_p() + dZ, itemStack.func_77946_l());

								if (itemStack.func_77942_o()) {
									entityItem.func_92059_d()
										.func_77982_d((NBTTagCompound) itemStack.func_77978_p().func_74737_b());
								}

								float factor = 0.05F;
								entityItem.field_70159_w = rand.nextGaussian() * factor;
								entityItem.field_70181_x = rand.nextGaussian() * factor + 0.2F;
								entityItem.field_70179_y = rand.nextGaussian() * factor;
								if (!world.field_72995_K) {
									world.func_72838_d(entityItem);
								}
							}
						}
						world.func_184148_a(null, player.field_70165_t, player.field_70163_u,
							player.field_70161_v, ModSounds.BLOCK_DISMANTLE,
							SoundCategory.BLOCKS, 0.6F, 1F);
						if (!world.field_72995_K) {
							world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
						}
						return EnumActionResult.SUCCESS;
					}

				}
			}
			return EnumActionResult.FAIL;
		} else {
			return EnumActionResult.FAIL;
		}
	}

	@SideOnly(Side.CLIENT)
	public boolean func_77662_d() {
		return true;
	}
}
