package techreborn.manual.pages;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ItemPlates;
import techreborn.manual.PageCollection;
import techreborn.manual.Reference;
import techreborn.manual.util.GuiButtonItemTexture;

import java.awt.*;

public class ContentsPage extends TitledPage {
	public ContentsPage(String name, PageCollection collection) {
		super(name, false, collection, Reference.CONTENTS_KEY, Color.white.getRGB());
	}

	@SuppressWarnings("unchecked")
	@Override
	public void func_73866_w_() {
		field_146292_n.clear();
		field_146292_n.add(new GuiButtonItemTexture(0, getXMin() + 20, getYMin() + 20, 0, 46, 100, 20,
			ItemPlates.getPlateByName("iron"), Reference.pageNames.GETTINGSTARTED_PAGE,
			ttl(Reference.GETTINGSTARTED_KEY)));
		field_146292_n.add(new GuiButtonItemTexture(1, getXMin() + 20, getYMin() + 40, 0, 46, 100, 20,
			new ItemStack(ModBlocks.SOLID_FUEL_GENEREATOR), Reference.pageNames.GENERATINGPOWER_PAGE,
			ttl(Reference.GENERATINGPOWER_KEY)));
		field_146292_n.add(new GuiButtonItemTexture(2, getXMin() + 20, getYMin() + 60, 0, 46, 100, 20,
			new ItemStack(ModBlocks.ELECTRIC_FURNACE), Reference.pageNames.BASICMACHINES_PAGE,
			ttl(Reference.BASICMACHINES_KEY)));
		field_146292_n.add(new GuiButtonItemTexture(3, getXMin() + 20, getYMin() + 80, 0, 46, 100, 20,
			new ItemStack(ModBlocks.INDUSTRIAL_BLAST_FURNACE), Reference.pageNames.ADVANCEDMACHINES_PAGE,
			ttl(Reference.ADVANCEDMACHINES_KEY)));
		field_146292_n.add(new GuiButtonItemTexture(4, getXMin() + 20, getYMin() + 100, 0, 46, 100, 20,
			new ItemStack(ModItems.STEEL_DRILL), Reference.pageNames.TOOLS_PAGE, ttl(Reference.TOOLS_KEY)));
	}

	@Override
	public void renderBackgroundLayer(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
		super.renderBackgroundLayer(minecraft, offsetX, offsetY, mouseX, mouseY);
	}

	@Override
	public void func_146284_a(GuiButton button) {
		if (button.field_146127_k == 0)
			collection.changeActivePage(Reference.pageNames.GETTINGSTARTED_PAGE);
		if (button.field_146127_k == 1)
			collection.changeActivePage(Reference.pageNames.GENERATINGPOWER_PAGE);
		if (button.field_146127_k == 2)
			collection.changeActivePage(Reference.pageNames.BASICMACHINES_PAGE);
		if (button.field_146127_k == 3)
			collection.changeActivePage(Reference.pageNames.ADVANCEDMACHINES_PAGE);
		if (button.field_146127_k == 4)
			collection.changeActivePage(Reference.pageNames.TOOLS_PAGE);
	}
}
