package techreborn.manual.pages;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import techreborn.init.ModItems;
import techreborn.manual.PageCollection;
import techreborn.manual.Reference;
import techreborn.manual.util.ButtonUtil;
import techreborn.manual.util.GuiButtonItemTexture;

import java.awt.*;

public class ToolsPage extends TitledPage {
	public ToolsPage(String name, PageCollection collection) {
		super(name, false, collection, Reference.TOOLS_KEY, Color.white.getRGB());
	}

	@Override
	public void func_73866_w_() {
		field_146292_n.clear();
		ButtonUtil.addBackButton(0, field_146294_l / 2 - 60, field_146295_m / 2 + 64, field_146292_n);
		ButtonUtil.addNextButton(1, field_146294_l / 2 + 40, field_146295_m / 2 + 64, field_146292_n);
		field_146292_n.add(new GuiButtonItemTexture(2, getXMin() + 20, getYMin() + 20, 0, 46, 100, 20,
			new ItemStack(ModItems.STEEL_DRILL), ModItems.STEEL_DRILL.func_77658_a(),
			ttl(ModItems.STEEL_DRILL.func_77658_a() + ".name")));
		field_146292_n.add(new GuiButtonItemTexture(3, getXMin() + 20, getYMin() + 40, 0, 46, 100, 20,
			new ItemStack(ModItems.DIAMOND_DRILL), ModItems.DIAMOND_DRILL.func_77658_a(),
			ttl(ModItems.DIAMOND_DRILL.func_77658_a() + ".name")));
		field_146292_n.add(new GuiButtonItemTexture(4, getXMin() + 20, getYMin() + 60, 0, 46, 100, 20,
			new ItemStack(ModItems.ADVANCED_DRILL), ModItems.ADVANCED_DRILL.func_77658_a(),
			ttl(ModItems.ADVANCED_DRILL.func_77658_a() + ".name")));
		field_146292_n.add(new GuiButtonItemTexture(5, getXMin() + 20, getYMin() + 80, 0, 46, 100, 20,
			new ItemStack(ModItems.STEEL_CHAINSAW), ModItems.STEEL_CHAINSAW.func_77658_a(),
			ttl(ModItems.STEEL_CHAINSAW.func_77658_a() + ".name")));
		field_146292_n.add(new GuiButtonItemTexture(6, getXMin() + 20, getYMin() + 100, 0, 46, 100, 20,
			new ItemStack(ModItems.DIAMOND_CHAINSAW), ModItems.DIAMOND_CHAINSAW.func_77658_a(),
			ttl(ModItems.DIAMOND_CHAINSAW.func_77658_a() + ".name")));
		field_146292_n.add(new GuiButtonItemTexture(7, getXMin() + 20, getYMin() + 120, 0, 46, 100, 20,
			new ItemStack(ModItems.ADVANCED_CHAINSAW), ModItems.ADVANCED_CHAINSAW.func_77658_a(),
			ttl(ModItems.ADVANCED_CHAINSAW.func_77658_a() + ".name")));
	}

	@Override
	public void func_146284_a(GuiButton button) {
		if (button.field_146127_k == 0)
			collection.changeActivePage(Reference.pageNames.CONTENTS_PAGE);
		if (button.field_146127_k == 1) {
			field_146292_n.clear();
			ButtonUtil.addBackButton(0, field_146294_l / 2 - 60, field_146295_m / 2 + 64, field_146292_n);
			field_146292_n.add(new GuiButtonItemTexture(8, getXMin() + 20, getYMin() + 20, 0, 46, 100, 20,
				new ItemStack(ModItems.OMNI_TOOL), ModItems.OMNI_TOOL.func_77658_a(),
				ttl(ModItems.OMNI_TOOL.func_77658_a() + ".name")));
			field_146292_n.add(new GuiButtonItemTexture(9, getXMin() + 20, getYMin() + 40, 0, 46, 100, 20,
				new ItemStack(ModItems.TREE_TAP), ModItems.TREE_TAP.func_77658_a(),
				ttl(ModItems.TREE_TAP.func_77658_a() + ".name")));
		}
		if (button.field_146127_k == 2)
			collection.changeActivePage(ModItems.STEEL_DRILL.func_77658_a() + ".name");
		if (button.field_146127_k == 3)
			collection.changeActivePage(ModItems.DIAMOND_DRILL.func_77658_a() + ".name");
		if (button.field_146127_k == 4)
			collection.changeActivePage(ModItems.ADVANCED_DRILL.func_77658_a() + ".name");
		if (button.field_146127_k == 5)
			collection.changeActivePage(ModItems.STEEL_CHAINSAW.func_77658_a() + ".name");
		if (button.field_146127_k == 6)
			collection.changeActivePage(ModItems.DIAMOND_CHAINSAW.func_77658_a() + ".name");
		if (button.field_146127_k == 7)
			collection.changeActivePage(ModItems.ADVANCED_CHAINSAW.func_77658_a() + ".name");
		if (button.field_146127_k == 8)
			collection.changeActivePage(ModItems.OMNI_TOOL.func_77658_a() + ".name");
		if (button.field_146127_k == 9)
			collection.changeActivePage(ModItems.TREE_TAP.func_77658_a() + ".name");
	}
}
