package techreborn.parts.powerCables;

import me.modmuss50.jsonDestroyer.api.ITexturedItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.RebornCore;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;
import reborncore.mcmultipart.item.ItemMultiPart;
import reborncore.mcmultipart.multipart.IMultipart;
import techreborn.client.TechRebornCreativeTab;
import techreborn.lib.ModInfo;
import techreborn.parts.TechRebornParts;

import java.util.List;

/**
 * Created by modmuss50 on 27/02/2016.
 */
public class ItemCables extends ItemMultiPart implements ITexturedItem {

	public ItemCables() {
		func_77637_a(TechRebornCreativeTab.instance);
		func_77627_a(true);
		func_77655_b("techreborn.cable");
		setNoRepair();
		RebornCore.jsonDestroyer.registerObject(this);
		ItemStandaloneCables.mcPartCable = this;
	}

	@Override
	public IMultipart createPart(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack,
	                             EntityPlayer player) {
		try {
			return TechRebornParts.multipartHashMap.get(EnumCableType.values()[stack.func_77952_i()]).newInstance();
		} catch (InstantiationException | IllegalAccessException e) {
			e.printStackTrace();
		}
		return null;
	}

	@Override
	// gets Unlocalized Name depending on meta data
	public String func_77667_c(ItemStack itemStack) {
		int meta = itemStack.func_77952_i();
		if (meta < 0 || meta >= EnumCableType.values().length) {
			meta = 0;
		}

		return super.func_77658_a() + "." + EnumCableType.values()[meta];
	}

	@Override
	public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
		for (int meta = 0; meta < EnumCableType.values().length; ++meta) {
			subItems.add(new ItemStack(itemIn, 1, meta));
		}
	}

	@Override
	public String getTextureName(int damage) {
		return ModInfo.MOD_ID + ":items/cables/" + EnumCableType.values()[damage].func_176610_l();
	}

	@Override
	public int getMaxMeta() {
		return EnumCableType.values().length;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
		return new ModelResourceLocation(ModInfo.MOD_ID + ":" + func_77667_c(stack).substring(5), "inventory");
	}

	@Override
	public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
		EnumCableType type = EnumCableType.values()[stack.func_77952_i()];
		tooltip.add(TextFormatting.GRAY + I18n.func_74838_a("desc.transfer") + " " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted(type.transferRate));
		tooltip.add(TextFormatting.GRAY + I18n.func_74838_a("desc.tier") + " " + TextFormatting.GOLD + StringUtils.toFirstCapitalAllLowercase(type.tier.toString()));
		if (type.canKill) {
			tooltip.add(TextFormatting.RED + I18n.func_74838_a("desc.uninsulatedCable"));
		}
	}
}
