package techreborn.tiles;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.*;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.registry.GameRegistry;

import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.recipes.RecipeTranslator;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

import techreborn.api.Reference;
import techreborn.api.recipe.machines.AlloySmelterRecipe;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;

public class TileAlloyFurnace extends TileLegacyMachineBase
implements IWrenchable, IInventoryProvider, IContainerProvider {

	public int tickTime;
	public Inventory inventory = new Inventory(4, "TileAlloyFurnace", 64, this);
	public int burnTime;
	public int currentItemBurnTime;
	public int cookTime;
	int input1 = 0;
	int input2 = 1;
	int output = 2;
	int fuel = 3;

	public TileAlloyFurnace() {

	}

	/**
	 * Returns the number of ticks that the supplied fuel item will keep the
	 * furnace burning, or 0 if the item isn't fuel
	 */
	public static int getItemBurnTime(final ItemStack stack) {
		if (stack == null) {
			return 0;
		} else {
			final Item item = stack.func_77973_b();

			if (item instanceof ItemBlock && Block.func_149634_a(item) != Blocks.field_150350_a) {
				final Block block = Block.func_149634_a(item);

				if (block == Blocks.field_150376_bx) {
					return 150;
				}

				if (block.func_149688_o(block.func_176223_P()) == Material.field_151575_d) {
					return 300;
				}

				if (block == Blocks.field_150402_ci) {
					return 16000;
				}
			}

			if (item instanceof ItemTool && ((ItemTool) item).func_77861_e().equals("WOOD"))
				return 200;
			if (item instanceof ItemSword && ((ItemSword) item).func_150932_j().equals("WOOD"))
				return 200;
			// if (item instanceof ItemHoe && ((ItemHoe)
			// item).getToolMaterialName().equals("WOOD")) return 200;
			if (item == Items.field_151055_y)
				return 100;
			if (item == Items.field_151044_h)
				return 1600;
			if (item == Items.field_151129_at)
				return 20000;
			if (item == Item.func_150898_a(Blocks.field_150345_g))
				return 100;
			if (item == Items.field_151072_bj)
				return 2400;
			return GameRegistry.getFuelValue(stack);
		}
	}

	@Override
	public void updateEntity() {
		super.updateEntity();
		final boolean flag = this.burnTime > 0;
		boolean flag1 = false;
		if (this.burnTime > 0) {
			--this.burnTime;
		}
		if (!this.field_145850_b.field_72995_K) {
			if (this.burnTime != 0 || this.func_70301_a(this.input1) != null && this.func_70301_a(this.fuel) != null) {
				if (this.burnTime == 0 && this.canSmelt()) {
					this.currentItemBurnTime = this.burnTime = TileAlloyFurnace.getItemBurnTime(this.func_70301_a(this.fuel));
					if (this.burnTime > 0) {
						flag1 = true;
						if (this.func_70301_a(this.fuel) != null) {
							this.func_70298_a(this.fuel, 1);
						}
					}
				}
				if (this.isBurning() && this.canSmelt()) {
					++this.cookTime;
					if (this.cookTime == 200) {
						this.cookTime = 0;
						this.smeltItem();
						flag1 = true;
					}
				} else {
					this.cookTime = 0;
				}
			}
			if (flag != this.burnTime > 0) {
				flag1 = true;
				// TODO sync on/off
			}
		}
		if (flag1) {
			this.func_70296_d();
		}
	}

	public boolean hasAllInputs(final IBaseRecipeType recipeType) {
		if (recipeType == null) {
			return false;
		}
		for (final Object input : recipeType.getInputs()) {
			boolean hasItem = false;
			boolean useOreDict = input instanceof String || recipeType.useOreDic();
			boolean checkSize = input instanceof ItemStack;
			for (int inputslot = 0; inputslot < 2; inputslot++) {
				if (ItemUtils.isInputEqual(input, inventory.func_70301_a(inputslot), true, true,
					useOreDict)) {
					ItemStack stack = RecipeTranslator.getStackFromObject(input);
					if(!checkSize || inventory.func_70301_a(inputslot).field_77994_a >= stack.field_77994_a){
						hasItem = true;
					}
				}
			}
			if (!hasItem)
				return false;
		}
		return true;
	}

	private boolean canSmelt() {
		if (this.func_70301_a(this.input1) == null || this.func_70301_a(this.input2) == null) {
			return false;
		} else {
			ItemStack itemstack = null;
			for (final IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName(Reference.alloySmelteRecipe)) {
				if (this.hasAllInputs(recipeType)) {
					itemstack = recipeType.getOutput(0);
					break;
				}
			}

			if (itemstack == null)
				return false;
			if (this.func_70301_a(this.output) == null)
				return true;
			if (!this.func_70301_a(this.output).func_77969_a(itemstack))
				return false;
			final int result = this.func_70301_a(this.output).field_77994_a + itemstack.field_77994_a;
			return result <= this.func_70297_j_() && result <= this.func_70301_a(this.output).func_77976_d(); // Forge
			// BugFix:
			// Make
			// it
			// respect
			// stack
			// sizes
			// properly.
		}
	}

	/**
	 * Turn one item from the furnace source stack into the appropriate smelted
	 * item in the furnace result stack
	 */
	public void smeltItem() {
		if (this.canSmelt()) {
			ItemStack itemstack = null;
			for (final IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName(Reference.alloySmelteRecipe)) {
				if (this.hasAllInputs(recipeType)) {
					itemstack = recipeType.getOutput(0);
					break;
				}
				if (itemstack != null) {
					break;
				}
			}

			if (this.func_70301_a(this.output) == null) {
				this.func_70299_a(this.output, itemstack.func_77946_l());
			} else if (this.func_70301_a(this.output).func_77973_b() == itemstack.func_77973_b()) {
				this.func_70298_a(this.output, -itemstack.field_77994_a);
			}

			for (final IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName(Reference.alloySmelteRecipe)) {
				boolean hasAllRecipes = true;
				if (this.hasAllInputs(recipeType)) {

				} else {
					hasAllRecipes = false;
				}
				if (hasAllRecipes) {
					for (Object input : recipeType.getInputs()) {
						boolean useOreDict = input instanceof String || recipeType.useOreDic();
						for (int inputSlot = 0; inputSlot < 2; inputSlot++) {
							if (ItemUtils.isInputEqual(input, this.inventory.func_70301_a(inputSlot), true, true,
									recipeType.useOreDic())) {
								int count = 1;
								if(input instanceof ItemStack){
									count = RecipeTranslator.getStackFromObject(input).field_77994_a;
								}
								inventory.func_70298_a(inputSlot, count);
								break;
							}
						}
					}
				}
			}

		}
	}

	/**
	 * Furnace isBurning
	 */
	public boolean isBurning() {
		return this.burnTime > 0;
	}

	public int getBurnTimeRemainingScaled(final int scale) {
		if (this.currentItemBurnTime == 0) {
			this.currentItemBurnTime = 200;
		}

		return this.burnTime * scale / this.currentItemBurnTime;
	}

	public int getCookProgressScaled(final int scale) {
		return this.cookTime * scale / 200;
	}

	@Override
	public boolean wrenchCanSetFacing(final EntityPlayer entityPlayer, final EnumFacing side) {
		return false;
	}

	@Override
	public EnumFacing getFacing() {
		return this.getFacingEnum();
	}

	@Override
	public boolean wrenchCanRemove(final EntityPlayer entityPlayer) {
		return entityPlayer.func_70093_af();
	}

	@Override
	public float getWrenchDropRate() {
		return 1.0F;
	}

	@Override
	public ItemStack getWrenchDrop(final EntityPlayer entityPlayer) {
		return new ItemStack(ModBlocks.IRON_ALLOY_FURNACE, 1);
	}

	public boolean isComplete() {
		return false;
	}

	@Override
	public Inventory getInventory() {
		return this.inventory;
	}

	@Override
	public int[] func_180463_a(final EnumFacing side) {
		return new int[] { 0, 1, 2 };
	}

	@Override
	public boolean func_180462_a(final int index, final ItemStack itemStackIn, final EnumFacing direction) {
		return index == 0 || index == 1;
	}

	@Override
	public boolean func_180461_b(final int index, final ItemStack stack, final EnumFacing direction) {
		return index == 2;
	}

	public int getBurnTime()
	{
		return this.burnTime;
	}

	public void setBurnTime(final int burnTime)
	{
		this.burnTime = burnTime;
	}

	public int getCurrentItemBurnTime()
	{
		return this.currentItemBurnTime;
	}

	public void setCurrentItemBurnTime(final int currentItemBurnTime)
	{
		this.currentItemBurnTime = currentItemBurnTime;
	}

	public int getCookTime()
	{
		return this.cookTime;
	}

	public void setCookTime(final int cookTime)
	{
		this.cookTime = cookTime;
	}

	@Override
	public BuiltContainer createContainer(final EntityPlayer player) {
		return new ContainerBuilder("alloyfurnace").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142)
				.addInventory().tile(this)
				.filterSlot(0, 47, 17,
						stack -> RecipeHandler.recipeList.stream()
								.anyMatch(recipe -> recipe instanceof AlloySmelterRecipe
										&& ItemUtils.isInputEqual(recipe.getInputs().get(0), stack, true, true, true)))
				.filterSlot(1, 65, 17,
						stack -> RecipeHandler.recipeList.stream()
								.anyMatch(recipe -> recipe instanceof AlloySmelterRecipe
										&& ItemUtils.isInputEqual(recipe.getInputs().get(1), stack, true, true, true)))
				.outputSlot(2, 116, 35).fuelSlot(3, 56, 53).syncIntegerValue(this::getBurnTime, this::setBurnTime)
				.syncIntegerValue(this::getCookTime, this::setCookTime)
				.syncIntegerValue(this::getCurrentItemBurnTime, this::setCurrentItemBurnTime).addInventory().create();
	}
}
