package techreborn.tiles;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;

import reborncore.api.tile.IInventoryProvider;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;

import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;

public class TileIronFurnace extends TileLegacyMachineBase
		implements IInventoryProvider, ISidedInventory, IContainerProvider {

	private static final int[] SLOTS_TOP = new int[] { 0 };
	private static final int[] SLOTS_BOTTOM = new int[] { 2, 1 };
	private static final int[] SLOTS_SIDES = new int[] { 1 };

	public int tickTime;
	public Inventory inventory = new Inventory(3, "TileIronFurnace", 64, this);
	public int fuel;
	public int fuelGague;
	public int progress;
	public int fuelScale = 200;
	int input1 = 0;
	int output = 1;
	int fuelslot = 2;
	boolean active = false;

	public int gaugeProgressScaled(final int scale) {
		return this.progress * scale / this.fuelScale;
	}

	public int gaugeFuelScaled(final int scale) {
		if (this.fuelGague == 0) {
			this.fuelGague = this.fuel;
			if (this.fuelGague == 0) {
				this.fuelGague = this.fuelScale;
			}
		}
		return this.fuel * scale / this.fuelGague;
	}

	@Override
	public void updateEntity() {
		final boolean burning = this.isBurning();
		boolean updateInventory = false;
		if (this.fuel > 0) {
			this.fuel--;
			this.updateState();
		}
		if (this.fuel <= 0 && this.canSmelt()) {
			this.fuel = this.fuelGague = (int) (TileEntityFurnace.func_145952_a(this.func_70301_a(this.fuelslot)) * 1.25);
			if (this.fuel > 0) {
				if (this.func_70301_a(this.fuelslot).func_77973_b().func_77634_r()) // Fuel
					// slot
				{
					this.func_70299_a(this.fuelslot, new ItemStack(this.func_70301_a(this.fuelslot).func_77973_b().func_77668_q()));
				} else if (this.func_70301_a(this.fuelslot).field_77994_a > 1) {
					this.func_70298_a(this.fuelslot, 1);
				} else if (this.func_70301_a(this.fuelslot).field_77994_a == 1) {
					this.func_70299_a(this.fuelslot, null);
				}
				updateInventory = true;
			}
		}
		if (this.isBurning() && this.canSmelt()) {
			this.progress++;
			if (this.progress >= this.fuelScale) {
				this.progress = 0;
				this.cookItems();
				updateInventory = true;
			}
		} else {
			this.progress = 0;
		}
		if (burning != this.isBurning()) {
			updateInventory = true;
		}
		if (updateInventory) {
			this.func_70296_d();
		}
	}

	public void cookItems() {
		if (this.canSmelt()) {
			final ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));

			if (this.func_70301_a(this.output) == null) {
				this.func_70299_a(this.output, itemstack.func_77946_l());
			} else if (this.func_70301_a(this.output).func_77969_a(itemstack)) {
				this.func_70301_a(this.output).field_77994_a += (itemstack.field_77994_a);
			}
			if (this.func_70301_a(this.input1).field_77994_a > 1) {
				this.func_70298_a(this.input1, 1);
			} else {
				this.func_70299_a(this.input1, null);
			}
		}
	}

	public boolean canSmelt() {
		if (this.func_70301_a(this.input1) == null)
			return false;
		final ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));
		if (itemstack == null)
			return false;
		if (this.func_70301_a(this.output) == null)
			return true;
		if (!this.func_70301_a(this.output).func_77969_a(itemstack))
			return false;
		final int result = this.func_70301_a(this.output).field_77994_a + itemstack.field_77994_a;
		return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
	}

	public boolean isBurning() {
		return this.fuel > 0;
	}

	public ItemStack getResultFor(final ItemStack stack) {
		final ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
		if (result != null) {
			return result.func_77946_l();
		}
		return null;
	}

	public void updateState() {
		final IBlockState BlockStateContainer = this.field_145850_b.func_180495_p(this.field_174879_c);
		if (BlockStateContainer.func_177230_c() instanceof BlockMachineBase) {
			final BlockMachineBase blockMachineBase = (BlockMachineBase) BlockStateContainer.func_177230_c();
			if (BlockStateContainer.func_177229_b(BlockMachineBase.ACTIVE) != this.fuel > 0)
				blockMachineBase.setActive(this.fuel > 0, this.field_145850_b, this.field_174879_c);
		}
	}

	@Override
	public Inventory getInventory() {
		return this.inventory;
	}

	@Override
	public int[] func_180463_a(final EnumFacing side) {
		return side == EnumFacing.DOWN ? TileIronFurnace.SLOTS_BOTTOM : side == EnumFacing.UP ? TileIronFurnace.SLOTS_TOP : TileIronFurnace.SLOTS_SIDES;
	}

	@Override
	public boolean func_180462_a(final int index, final ItemStack itemStackIn, final EnumFacing direction) {
		return this.func_94041_b(index, itemStackIn);
	}

	@Override
	public boolean func_180461_b(final int index, final ItemStack stack, final EnumFacing direction) {
		if (direction == EnumFacing.DOWN && index == 1) {
			final Item item = stack.func_77973_b();

			if (item != Items.field_151131_as && item != Items.field_151133_ar) {
				return false;
			}
		}

		return true;
	}

	public int getBurnTime() {
		return this.fuel;
	}

	public void setBurnTime(final int burnTime) {
		this.fuel = burnTime;
	}

	public int getTotalBurnTime() {
		return this.fuelGague;
	}

	public void setTotalBurnTime(final int totalBurnTime) {
		this.fuelGague = totalBurnTime;
	}

	@Override
	public BuiltContainer createContainer(final EntityPlayer player) {
		return new ContainerBuilder("ironfurnace").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142)
				.addInventory().tile(this).slot(0, 56, 17).outputSlot(1, 116, 34).fuelSlot(2, 56, 53)
				.syncIntegerValue(this::getBurnTime, this::setBurnTime)
				.syncIntegerValue(this::getTotalBurnTime, this::setTotalBurnTime).addInventory().create();
	}
}
