package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.WorldUtils;

import java.util.Iterator;

public class TilePlayerDectector extends TilePowerAcceptor {

	public String owenerUdid = "";
	boolean redstone = false;

	public TilePlayerDectector() {
		super(1);
	}

	@Override
	public double getMaxPower() {
		return 10000;
	}

	@Override
	public boolean canAcceptEnergy(EnumFacing direction) {
		return true;
	}

	@Override
	public boolean canProvideEnergy(EnumFacing direction) {
		return false;
	}

	@Override
	public double getMaxOutput() {
		return 0;
	}

	@Override
	public double getMaxInput() {
		return 32;
	}

	@Override
	public EnumPowerTier getTier() {
		return EnumPowerTier.LOW;
	}

	@Override
	public void updateEntity() {
		super.updateEntity();
		if (!field_145850_b.field_72995_K && field_145850_b.func_72820_D() % 20 == 0) {
			boolean lastRedstone = redstone;
			redstone = false;
			if (canUseEnergy(10)) {
				Iterator tIterator = super.field_145850_b.field_73010_i.iterator();
				while (tIterator.hasNext()) {
					EntityPlayer player = (EntityPlayer) tIterator.next();
					if (player.func_70092_e((double) super.func_174877_v().func_177958_n() + 0.5D,
						(double) super.func_174877_v().func_177956_o() + 0.5D, (double) super.func_174877_v().func_177952_p() + 0.5D) <= 256.0D) {
						BlockMachineBase blockMachineBase = (BlockMachineBase) field_145850_b.func_180495_p(field_174879_c).func_177230_c();
						int meta = blockMachineBase.func_176201_c(field_145850_b.func_180495_p(field_174879_c));
						if (meta == 0) {// ALL
							redstone = true;
						} else if (meta == 1) {// Others
							if (!owenerUdid.isEmpty() && !owenerUdid.equals(player.func_110124_au().toString())) {
								redstone = true;
							}
						} else {// You
							if (!owenerUdid.isEmpty() && owenerUdid.equals(player.func_110124_au().toString())) {
								redstone = true;
							}
						}
						redstone = true;
					}
				}
				useEnergy(10);
			}
			if (lastRedstone != redstone) {
				WorldUtils.updateBlock(field_145850_b, func_174877_v());
				field_145850_b.func_175685_c(func_174877_v(), field_145850_b.func_180495_p(func_174877_v()).func_177230_c());
			}
		}
	}

	public boolean isProvidingPower() {
		return redstone;
	}

	@Override
	public void func_145839_a(NBTTagCompound tag) {
		super.func_145839_a(tag);
		owenerUdid = tag.func_74779_i("ownerID");
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound tag) {
		super.func_189515_b(tag);
		tag.func_74778_a("ownerID", owenerUdid);
		return tag;
	}
}
