package techreborn.tiles;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Tank;
import techreborn.config.ConfigTechReborn;

import java.util.List;

/**
 * Created by modmuss50 on 08/05/2016.
 */
public class TilePump extends TilePowerAcceptor {

	public Tank tank = new Tank("TilePump", 10000, this);

	public TilePump() {
		super(1);
	}

	@Override
	public void updateEntity() {
		super.updateEntity();
		if (!field_145850_b.field_72995_K && field_145850_b.func_82737_E() % 10 == 0 && !tank.isFull() && tank.getCapacity() - tank.getFluidAmount() >= 1000 && canUseEnergy(ConfigTechReborn.pumpExtractEU)) {
			FluidStack fluidStack = drainBlock(field_145850_b, field_174879_c.func_177977_b(), false);
			if (fluidStack != null) {
				tank.fill(drainBlock(field_145850_b, field_174879_c.func_177977_b(), true), true);
				useEnergy(ConfigTechReborn.pumpExtractEU);
			}
			tank.compareAndUpdate();
		}
	}

	@Override
	public void addInfo(List<String> info, boolean isRealTile) {
		super.addInfo(info, isRealTile);
		info.add(TextFormatting.LIGHT_PURPLE + "Eu per extract " + TextFormatting.GREEN
			+ PowerSystem.getLocaliszedPower(ConfigTechReborn.pumpExtractEU));
		info.add(TextFormatting.LIGHT_PURPLE + "Speed: " + TextFormatting.GREEN
			+ "1000mb/5 sec");
	}

	public static FluidStack drainBlock(World world, BlockPos pos, boolean doDrain) {
		IBlockState state = world.func_180495_p(pos);
		Block block = state.func_177230_c();
		Fluid fluid = FluidRegistry.lookupFluidForBlock(block);

		if (fluid != null && FluidRegistry.isFluidRegistered(fluid)) {
			if (block instanceof IFluidBlock) {
				IFluidBlock fluidBlock = (IFluidBlock) block;
				if (!fluidBlock.canDrain(world, pos)) {
					return null;
				}
				return fluidBlock.drain(world, pos, doDrain);
			} else {
				//Checks if source
				int level = state.func_177229_b(BlockLiquid.field_176367_b);
				if (level != 0) {
					return null;
				}
				if (doDrain) {
					world.func_175698_g(pos);
				}
				return new FluidStack(fluid, 1000);
			}
		} else {
			return null;
		}
	}

	@Override
	public double getMaxPower() {
		return 10000;
	}

	@Override
	public boolean canAcceptEnergy(EnumFacing direction) {
		return true;
	}

	@Override
	public boolean canProvideEnergy(EnumFacing direction) {
		return false;
	}

	@Override
	public double getMaxOutput() {
		return 0;
	}

	@Override
	public double getMaxInput() {
		return 32;
	}

	@Override
	public EnumPowerTier getTier() {
		return EnumPowerTier.LOW;
	}

	@Override
	public void func_145839_a(NBTTagCompound tagCompound) {
		super.func_145839_a(tagCompound);
		readFromNBTWithoutCoords(tagCompound);
	}

	public void readFromNBTWithoutCoords(NBTTagCompound tagCompound) {
		tank.readFromNBT(tagCompound);
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
		super.func_189515_b(tagCompound);
		writeToNBTWithoutCoords(tagCompound);
		return tagCompound;
	}

	public NBTTagCompound writeToNBTWithoutCoords(NBTTagCompound tagCompound) {
		tank.writeToNBT(tagCompound);
		return tagCompound;
	}

	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
		if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
			return true;
		}
		return super.hasCapability(capability, facing);
	}

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
		if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
			return (T) tank;
		}
		return super.getCapability(capability, facing);
	}
}
