package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

import reborncore.api.IListInfoProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;

import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;

import java.util.List;

public class TileQuantumTank extends TileLegacyMachineBase
implements IInventoryProvider, IWrenchable, IListInfoProvider, IContainerProvider {

	public Tank tank = new Tank("TileQuantumTank", Integer.MAX_VALUE, this);
	public Inventory inventory = new Inventory(3, "TileQuantumTank", 64, this);

	@Override
	public void func_145839_a(final NBTTagCompound tagCompound) {
		super.func_145839_a(tagCompound);
		this.readFromNBTWithoutCoords(tagCompound);
	}

	public void readFromNBTWithoutCoords(final NBTTagCompound tagCompound) {
		this.tank.readFromNBT(tagCompound);
	}

	@Override
	public NBTTagCompound func_189515_b(final NBTTagCompound tagCompound) {
		super.func_189515_b(tagCompound);
		this.writeToNBTWithoutCoords(tagCompound);
		return tagCompound;
	}

	public NBTTagCompound writeToNBTWithoutCoords(final NBTTagCompound tagCompound) {
		this.tank.writeToNBT(tagCompound);
		return tagCompound;
	}

	@Override
	public void onDataPacket(final NetworkManager net, final SPacketUpdateTileEntity packet) {
		this.field_145850_b.func_147458_c(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(),
				this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
		this.func_145839_a(packet.func_148857_g());
	}

	@Override
	public void updateEntity() {
		super.updateEntity();
		if (!this.field_145850_b.field_72995_K) {
			if (FluidUtils.drainContainers(this.tank, this.inventory, 0, 1)
					|| FluidUtils.fillContainers(this.tank, this.inventory, 0, 1, this.tank.getFluidType()))
				this.syncWithAll();

			if (this.tank.getFluidType() != null && this.func_70301_a(2) == null) {
				this.inventory.func_70299_a(2, new ItemStack(this.tank.getFluidType().getBlock()));
			} else if (this.tank.getFluidType() == null && this.func_70301_a(2) != null) {
				this.func_70299_a(2, null);
			}
		}
	}

	@Override
	public boolean hasCapability(final Capability<?> capability, final EnumFacing facing) {
		if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
			return true;
		}
		return super.hasCapability(capability, facing);
	}

	@Override
	public <T> T getCapability(final Capability<T> capability, final EnumFacing facing) {
		if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
			return (T) this.tank;
		}
		return super.getCapability(capability, facing);
	}

	@Override
	public boolean wrenchCanSetFacing(final EntityPlayer entityPlayer, final EnumFacing side) {
		return false;
	}

	@Override
	public EnumFacing getFacing() {
		return this.getFacingEnum();
	}

	@Override
	public boolean wrenchCanRemove(final EntityPlayer entityPlayer) {
		return entityPlayer.func_70093_af();
	}

	@Override
	public float getWrenchDropRate() {
		return 1F;
	}

	@Override
	public ItemStack getWrenchDrop(final EntityPlayer entityPlayer) {
		return this.getDropWithNBT();
	}

	public ItemStack getDropWithNBT() {
		final NBTTagCompound tileEntity = new NBTTagCompound();
		final ItemStack dropStack = new ItemStack(ModBlocks.QUANTUM_TANK, 1);
		this.writeToNBTWithoutCoords(tileEntity);
		dropStack.func_77982_d(new NBTTagCompound());
		dropStack.func_77978_p().func_74782_a("tileEntity", tileEntity);
		return dropStack;
	}

	@Override
	public void addInfo(final List<String> info, final boolean isRealTile) {
		if (isRealTile) {
			if (this.tank.getFluid() != null) {
				info.add(this.tank.getFluidAmount() + " of " + this.tank.getFluidType().getName());
			} else {
				info.add("Empty");
			}
		}
		info.add("Capacity " + this.tank.getCapacity() + " mb");

	}

	@Override
	public Inventory getInventory() {
		return this.inventory;
	}

	@Override
	public BuiltContainer createContainer(final EntityPlayer player) {
		return new ContainerBuilder("quantumtank").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142)
				.addInventory().tile(this).fluidSlot(0, 80, 17).outputSlot(1, 80, 53).fakeSlot(2, 59, 42).addInventory()
				.create();
	}
}
