package techreborn.tiles;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;

import techreborn.api.ScrapboxList;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;

import java.util.Random;

public class TileScrapboxinator extends TilePowerAcceptor
implements IWrenchable, IInventoryProvider, ISidedInventory, IContainerProvider {

	public Inventory inventory = new Inventory(6, "TileScrapboxinator", 64, this);
	public int capacity = 1000;
	public int cost = 20;
	public int progress;
	public int time = 200;
	public int chance = 4;
	public int random;
	public int input1 = 0;
	public int output = 1;

	public TileScrapboxinator() {
		super(1);
	}

	public int gaugeProgressScaled(final int scale) {
		return this.progress * scale / this.time;
	}

	@Override
	public void updateEntity() {
		final boolean burning = this.isBurning();
		boolean updateInventory = false;
		if (this.getEnergy() <= this.cost && this.canOpen()) {
			if (this.getEnergy() > this.cost) {
				updateInventory = true;
			}
		}
		if (this.isBurning() && this.canOpen()) {
			this.updateState();

			this.progress++;
			if (this.progress >= this.time) {
				this.progress = 0;
				this.recycleItems();
				updateInventory = true;
			}
		} else {
			this.progress = 0;
			this.updateState();
		}
		if (burning != this.isBurning()) {
			updateInventory = true;
		}
		if (updateInventory) {
			this.func_70296_d();
		}
	}

	public void recycleItems() {
		if (this.canOpen() && !this.field_145850_b.field_72995_K) {
			final int random = new Random().nextInt(ScrapboxList.stacks.size());
			final ItemStack out = ScrapboxList.stacks.get(random).func_77946_l();
			if (this.func_70301_a(this.output) == null) {
				this.useEnergy(this.cost);
				this.func_70299_a(this.output, out);
			}

			if (this.func_70301_a(this.input1).field_77994_a > 1) {
				this.useEnergy(this.cost);
				this.func_70298_a(this.input1, 1);
			} else {
				this.useEnergy(this.cost);
				this.func_70299_a(this.input1, null);
			}
		}
	}

	public boolean canOpen() {
		return this.func_70301_a(this.input1) != null && this.func_70301_a(this.output) == null;
	}

	public boolean isBurning() {
		return this.getEnergy() > this.cost;
	}

	public void updateState() {
		final IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
		if (blockState.func_177230_c() instanceof BlockMachineBase) {
			final BlockMachineBase blockMachineBase = (BlockMachineBase) blockState.func_177230_c();
			if (blockState.func_177229_b(BlockMachineBase.ACTIVE) != this.progress > 0)
				blockMachineBase.setActive(this.progress > 0, this.field_145850_b, this.field_174879_c);
		}
	}

	@Override
	public boolean wrenchCanSetFacing(final EntityPlayer entityPlayer, final EnumFacing side) {
		return false;
	}

	@Override
	public EnumFacing getFacing() {
		return this.getFacingEnum();
	}

	@Override
	public boolean wrenchCanRemove(final EntityPlayer entityPlayer) {
		return entityPlayer.func_70093_af();
	}

	@Override
	public float getWrenchDropRate() {
		return 1.0F;
	}

	@Override
	public ItemStack getWrenchDrop(final EntityPlayer entityPlayer) {
		return new ItemStack(ModBlocks.SCRAPBOXINATOR, 1);
	}

	public boolean isComplete() {
		return false;
	}

	// ISidedInventory
	@Override
	public int[] func_180463_a(final EnumFacing side) {
		return side == EnumFacing.DOWN ? new int[] { 0, 1, 2 } : new int[] { 0, 1, 2 };
	}

	@Override
	public boolean func_180462_a(final int slotIndex, final ItemStack itemStack, final EnumFacing side) {
		if (slotIndex == 2)
			return false;
		if (slotIndex == 1) {
			if (itemStack.func_77973_b() == ModItems.SCRAP_BOX) {
				return true;
			}
		}
		return this.func_94041_b(slotIndex, itemStack);
	}

	@Override
	public boolean func_180461_b(final int slotIndex, final ItemStack itemStack, final EnumFacing side) {
		return slotIndex == 2;
	}

	@Override
	public double getMaxPower() {
		return this.capacity;
	}

	@Override
	public boolean canAcceptEnergy(final EnumFacing direction) {
		return true;
	}

	@Override
	public boolean canProvideEnergy(final EnumFacing direction) {
		return false;
	}

	@Override
	public double getMaxOutput() {
		return 0;
	}

	@Override
	public double getMaxInput() {
		return 32;
	}

	@Override
	public EnumPowerTier getTier() {
		return EnumPowerTier.MEDIUM;
	}

	@Override
	public Inventory getInventory() {
		return this.inventory;
	}

	public int getProgress() {
		return this.progress;
	}

	public void setProgress(final int progress) {
		this.progress = progress;
	}

	@Override
	public BuiltContainer createContainer(final EntityPlayer player) {
		return new ContainerBuilder("scrapboxinator").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142)
				.addInventory().tile(this).filterSlot(0, 56, 34, stack -> stack.func_77973_b() == ModItems.SCRAP_BOX)
				.outputSlot(1, 116, 34).upgradeSlot(2, 152, 8).upgradeSlot(3, 152, 26).upgradeSlot(4, 152, 44)
				.upgradeSlot(5, 152, 62).syncEnergyValue().syncIntegerValue(this::getProgress, this::setProgress)
				.addInventory().create();
	}
}
