package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import reborncore.api.IListInfoProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

import java.util.ArrayList;
import java.util.List;

public class TileTechStorageBase extends TileLegacyMachineBase
	implements IInventoryProvider, IWrenchable, IListInfoProvider, IDeepStorageUnit {

	public final int maxCapacity;
	public final Inventory inventory;
	public InvWrapper invWrapper;
	public ItemStack storedItem;

	public TileTechStorageBase(String name, int maxCapacity) {
		this.maxCapacity = maxCapacity;
		storedItem = null;
		inventory = new Inventory(3, name, maxCapacity, this);
	}

	@Override
	public void updateEntity() {
		if (!field_145850_b.field_72995_K) {
			if (this.func_70301_a(0) != null) {
				if (this.getStoredItemType() == null || (this.getStoredItemType() == null
					&& ItemUtils.isItemEqual(this.func_70301_a(0), this.func_70301_a(1), true, true))) {

					this.storedItem = this.func_70301_a(0);
					this.func_70299_a(0, null);
					this.syncWithAll();
				} else if (ItemUtils.isItemEqual(this.getStoredItemType(), this.func_70301_a(0), true, true)) {

					this.setStoredItemCount(this.func_70301_a(0).field_77994_a);
					this.func_70299_a(0, null);
					this.syncWithAll();
				}
			}

			if (this.storedItem != null) {
				if (this.func_70301_a(1) == null) {

					ItemStack delivered = this.storedItem.func_77946_l();
					delivered.field_77994_a = (Math.min(this.storedItem.field_77994_a, delivered.func_77976_d()));

					this.storedItem.field_77994_a -= (delivered.field_77994_a);

					if (this.storedItem.field_77994_a == 0)
						this.storedItem = null;

					this.func_70299_a(1, delivered);
					this.syncWithAll();
				} else if (ItemUtils.isItemEqual(this.storedItem, this.func_70301_a(1), true, true)
					&& this.func_70301_a(1).field_77994_a < this.func_70301_a(1).func_77976_d()) {

					int wanted = Math.min(this.storedItem.field_77994_a,
						this.func_70301_a(1).func_77976_d() - this.func_70301_a(1).field_77994_a);

					this.func_70301_a(1).field_77994_a = (this.func_70301_a(1).field_77994_a + wanted);
					this.storedItem.field_77994_a -= (wanted);

					if (this.storedItem.field_77994_a == 0)
						this.storedItem = null;
					this.syncWithAll();
				}
			}
		}
	}

	@Override
	public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
		field_145850_b.func_147458_c(func_174877_v().func_177958_n(), func_174877_v().func_177956_o(), func_174877_v().func_177952_p(), func_174877_v().func_177958_n(),
			func_174877_v().func_177956_o(), func_174877_v().func_177952_p());
		func_145839_a(packet.func_148857_g());
	}

	@Override
	public void func_145839_a(NBTTagCompound tagCompound) {
		super.func_145839_a(tagCompound);
		readFromNBTWithoutCoords(tagCompound);
	}

	public void readFromNBTWithoutCoords(NBTTagCompound tagCompound) {

		storedItem = null;

		if (tagCompound.func_74764_b("storedStack")) {
			storedItem = ItemStack.func_77949_a((NBTTagCompound) tagCompound.func_74781_a("storedStack"));
		}

		if (storedItem != null) {
			storedItem.field_77994_a = (tagCompound.func_74762_e("storedQuantity"));
		}
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
		super.func_189515_b(tagCompound);
		writeToNBTWithoutCoords(tagCompound);
		return tagCompound;
	}

	public NBTTagCompound writeToNBTWithoutCoords(NBTTagCompound tagCompound) {
		if (storedItem != null) {
			tagCompound.func_74782_a("storedStack", storedItem.func_77955_b(new NBTTagCompound()));
			tagCompound.func_74768_a("storedQuantity", storedItem.field_77994_a);
		} else {
			tagCompound.func_74768_a("storedQuantity", 0);
		}

		return tagCompound;
	}

	@Override
	public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
		return false;
	}

	@Override
	public EnumFacing getFacing() {
		return getFacingEnum();
	}

	@Override
	public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
		return entityPlayer.func_70093_af();
	}

	@Override
	public float getWrenchDropRate() {
		return 1F;
	}

	@Override
	public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
		return getDropWithNBT();
	}

	public ItemStack getDropWithNBT() {
		NBTTagCompound tileEntity = new NBTTagCompound();
		ItemStack dropStack = new ItemStack(this.func_145838_q(), 1);
		writeToNBTWithoutCoords(tileEntity);
		dropStack.func_77982_d(new NBTTagCompound());
		dropStack.func_77978_p().func_74782_a("tileEntity", tileEntity);
		return dropStack;
	}

	public List<ItemStack> getContentDrops() {
		ArrayList<ItemStack> stacks = new ArrayList<>();

		if (this.getStoredItemType() != null) {
			if (this.func_70301_a(1) != null)
				stacks.add(this.func_70301_a(1));
			for (int i = 0; i < this.getStoredCount() / 64; i++) {
				ItemStack droped = this.storedItem.func_77946_l();
				droped.field_77994_a = (64);
				stacks.add(droped);
			}
			if (this.getStoredCount() % 64 != 0) {
				ItemStack droped = this.storedItem.func_77946_l();
				droped.field_77994_a = (this.getStoredCount() % 64);
				stacks.add(droped);
			}
		}

		return stacks;
	}

	@Override
	public ItemStack getStoredItemType() {
		return this.storedItem == null ? this.func_70301_a(1) : this.storedItem;
	}

	@Override
	public void setStoredItemCount(int amount) {
		storedItem.field_77994_a += (amount);
		this.func_70296_d();
	}

	@Override
	public void setStoredItemType(ItemStack type, int amount) {
		this.storedItem = type;
		storedItem.field_77994_a = (amount);
		this.func_70296_d();
	}

	@Override
	public int getMaxStoredCount() {
		return this.maxCapacity;
	}

	public int getStoredCount() {
		return this.storedItem.field_77994_a;
	}

	@Override
	public void addInfo(List<String> info, boolean isRealTile) {
		if (isRealTile) {
			int size = 0;
			String name = "of nothing";
			if (storedItem != null) {
				name = storedItem.func_82833_r();
				size += storedItem.field_77994_a;
			}
			if (func_70301_a(1) != null) {
				name = func_70301_a(1).func_82833_r();
				size += func_70301_a(1).field_77994_a;
			}
			info.add(size + " " + name);
		}
	}

	@Override
	public Inventory getInventory() {
		return this.inventory;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T getCapability(final Capability<T> capability, final EnumFacing facing) {
		if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)
			return (T) this.getInvWrapper();
		return super.getCapability(capability, facing);
	}

	@Override
	public boolean hasCapability(final net.minecraftforge.common.capabilities.Capability<?> capability,
	                             @javax.annotation.Nullable
	                             final net.minecraft.util.EnumFacing facing) {
		return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
	}

	public InvWrapper getInvWrapper() {
		if (this.invWrapper == null)
			this.invWrapper = new InvWrapper(this);
		return this.invWrapper;
	}
}
