package techreborn.tiles.fusionReactor;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;

public class TileEntityFusionController extends TilePowerAcceptor implements IInventoryProvider, IContainerProvider {

	public Inventory inventory = new Inventory(3, "TileEntityFusionController", 64, this);

	// 0= no coils, 1 = coils
	public int coilStatus = 0;
	public int crafingTickTime = 0;
	public int finalTickTime = 0;
	public int neededPower = 0;
	int topStackSlot = 0;
	int bottomStackSlot = 1;
	int outputStackSlot = 2;
	FusionReactorRecipe currentRecipe = null;
	boolean hasStartedCrafting = false;

	public TileEntityFusionController() {
		super(4);
	}

	@Override
	public double getMaxPower() {
		return 100000000;
	}

	@Override
	public boolean canAcceptEnergy(final EnumFacing direction) {
		return !(direction == EnumFacing.DOWN || direction == EnumFacing.UP);
	}

	@Override
	public boolean canProvideEnergy(final EnumFacing direction) {
		return direction == EnumFacing.DOWN || direction == EnumFacing.UP;
	}

	@Override
	public double getMaxOutput() {
		if (!this.hasStartedCrafting) {
			return 0;
		}
		return 1000000;
	}

	@Override
	public double getMaxInput() {
		if (this.hasStartedCrafting) {
			return 0;
		}
		return 8192;
	}

	@Override
	public EnumPowerTier getTier() {
		return EnumPowerTier.EXTREME;
	}

	@Override
	public void func_145839_a(final NBTTagCompound tagCompound) {
		super.func_145839_a(tagCompound);
		this.crafingTickTime = tagCompound.func_74762_e("crafingTickTime");
		this.finalTickTime = tagCompound.func_74762_e("finalTickTime");
		this.neededPower = tagCompound.func_74762_e("neededPower");
		this.hasStartedCrafting = tagCompound.func_74767_n("hasStartedCrafting");
	}

	@Override
	public NBTTagCompound func_189515_b(final NBTTagCompound tagCompound) {
		super.func_189515_b(tagCompound);

		if (this.crafingTickTime == -1) {
			this.crafingTickTime = 0;
		}
		if (this.finalTickTime == -1) {
			this.finalTickTime = 0;
		}
		if (this.neededPower == -1) {
			this.neededPower = 0;
		}
		tagCompound.func_74768_a("crafingTickTime", this.crafingTickTime);
		tagCompound.func_74768_a("finalTickTime", this.finalTickTime);
		tagCompound.func_74768_a("neededPower", this.neededPower);
		tagCompound.func_74757_a("hasStartedCrafting", this.hasStartedCrafting);
		return tagCompound;
	}

	public boolean checkCoils() {
		if (this.isCoil(this.func_174877_v().func_177958_n() + 3, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 1)
				&& this.isCoil(this.func_174877_v().func_177958_n() + 3, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p())
				&& this.isCoil(this.func_174877_v().func_177958_n() + 3, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 1)
				&& this.isCoil(this.func_174877_v().func_177958_n() - 3, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 1)
				&& this.isCoil(this.func_174877_v().func_177958_n() - 3, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p())
				&& this.isCoil(this.func_174877_v().func_177958_n() - 3, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 1)
				&& this.isCoil(this.func_174877_v().func_177958_n() + 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 2)
				&& this.isCoil(this.func_174877_v().func_177958_n() + 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 1)
				&& this.isCoil(this.func_174877_v().func_177958_n() + 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 1)
				&& this.isCoil(this.func_174877_v().func_177958_n() + 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 2)
				&& this.isCoil(this.func_174877_v().func_177958_n() - 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 2)
				&& this.isCoil(this.func_174877_v().func_177958_n() - 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 1)
				&& this.isCoil(this.func_174877_v().func_177958_n() - 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 1)
				&& this.isCoil(this.func_174877_v().func_177958_n() - 2, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 2)
				&& this.isCoil(this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 3)
				&& this.isCoil(this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 2)
				&& this.isCoil(this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 2)
				&& this.isCoil(this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 3)
				&& this.isCoil(this.func_174877_v().func_177958_n() - 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 3)
				&& this.isCoil(this.func_174877_v().func_177958_n() - 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 2)
				&& this.isCoil(this.func_174877_v().func_177958_n() - 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 2)
				&& this.isCoil(this.func_174877_v().func_177958_n() - 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 3)
				&& this.isCoil(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 3)
				&& this.isCoil(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 3)) {
			this.coilStatus = 1;
			return true;
		}
		this.coilStatus = 0;
		return false;
	}

	private boolean isCoil(final int x, final int y, final int z) {
		return this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == ModBlocks.FUSION_COIL;
	}

	@Override
	public void updateEntity() {
		super.updateEntity();
		// TODO improve this code a lot

		if (this.field_145850_b.func_82737_E() % 20 == 0) {
			this.checkCoils();
		}

		if (!this.field_145850_b.field_72995_K) {
			if (this.coilStatus == 1) {
				if (this.currentRecipe == null) {
					if (this.inventory.hasChanged || this.crafingTickTime != 0) {
						for (final FusionReactorRecipe reactorRecipe : FusionReactorRecipeHelper.reactorRecipes) {
							if (ItemUtils.isItemEqual(this.func_70301_a(this.topStackSlot), reactorRecipe.getTopInput(), true,
									true, true)) {
								if (reactorRecipe.getBottomInput() != null) {
									if (!ItemUtils.isItemEqual(this.func_70301_a(this.bottomStackSlot),
											reactorRecipe.getBottomInput(), true, true, true)) {
										break;
									}
								}
								if (this.canFitStack(reactorRecipe.getOutput(), this.outputStackSlot, true)) {
									this.currentRecipe = reactorRecipe;
									if (this.crafingTickTime != 0) {
										this.finalTickTime = this.currentRecipe.getTickTime();
										this.neededPower = (int) this.currentRecipe.getStartEU();
									}
									this.hasStartedCrafting = false;
									this.crafingTickTime = 0;
									this.finalTickTime = this.currentRecipe.getTickTime();
									this.neededPower = (int) this.currentRecipe.getStartEU();
									break;
								}
							}
						}
					}
				} else {
					if (this.inventory.hasChanged) {
						if (!this.validateRecipe()) {
							this.resetCrafter();
							return;
						}
					}
					if (!this.hasStartedCrafting) {
						if (this.canUseEnergy(this.currentRecipe.getStartEU() + 64)) {
							this.useEnergy(this.currentRecipe.getStartEU());
							this.hasStartedCrafting = true;
						}
					} else {
						if (this.crafingTickTime < this.currentRecipe.getTickTime()) {
							if (this.currentRecipe.getEuTick() > 0) { // Power gen
								this.addEnergy(this.currentRecipe.getEuTick()); // Waste
								// power
								// if it
								// has
								// no
								// where
								// to go
								this.crafingTickTime++;
							} else { // Power user
								if (this.canUseEnergy(this.currentRecipe.getEuTick() * -1)) {
									this.setEnergy(this.getEnergy() - this.currentRecipe.getEuTick() * -1);
									this.crafingTickTime++;
								}
							}
						} else {
							if (this.canFitStack(this.currentRecipe.getOutput(), this.outputStackSlot, true)) {
								if (this.func_70301_a(this.outputStackSlot) == null) {
									this.func_70299_a(this.outputStackSlot, this.currentRecipe.getOutput().func_77946_l());
								} else {
									this.func_70298_a(this.outputStackSlot, -this.currentRecipe.getOutput().field_77994_a);
								}
								this.func_70298_a(this.topStackSlot, this.currentRecipe.getTopInput().field_77994_a);
								if (this.currentRecipe.getBottomInput() != null) {
									this.func_70298_a(this.bottomStackSlot, this.currentRecipe.getBottomInput().field_77994_a);
								}
								this.resetCrafter();
							}
						}
					}
				}
			} else {
				if (this.currentRecipe != null) {
					this.resetCrafter();
				}
			}
		}

		if (this.inventory.hasChanged) {
			this.inventory.hasChanged = false;
		}
	}

	private boolean validateRecipe() {
		if (ItemUtils.isItemEqual(this.func_70301_a(this.topStackSlot), this.currentRecipe.getTopInput(), true, true, true)) {
			if (this.currentRecipe.getBottomInput() != null) {
				if (!ItemUtils.isItemEqual(this.func_70301_a(this.bottomStackSlot), this.currentRecipe.getBottomInput(), true, true,
						true)) {
					return false;
				}
			}
			if (this.canFitStack(this.currentRecipe.getOutput(), this.outputStackSlot, true)) {
				return true;
			}
		}
		return false;
	}

	private void resetCrafter() {
		this.currentRecipe = null;
		this.crafingTickTime = -1;
		this.finalTickTime = -1;
		this.neededPower = -1;
		this.hasStartedCrafting = false;
	}

	public boolean canFitStack(final ItemStack stack, final int slot, final boolean oreDic) {// Checks to see if it can fit the stack
		if (stack == null) {
			return true;
		}
		if (this.inventory.func_70301_a(slot) == null) {
			return true;
		}
		if (ItemUtils.isItemEqual(this.inventory.func_70301_a(slot), stack, true, true, oreDic)) {
			if (stack.field_77994_a + this.inventory.func_70301_a(slot).field_77994_a <= stack.func_77976_d()) {
				return true;
			}
		}
		return false;
	}

	@Override
	public String func_70005_c_() {
		return null;
	}

	@Override
	public boolean func_145818_k_() {
		return false;
	}

	@Override
	public ITextComponent func_145748_c_() {
		return null;
	}

	@Override
	public Inventory getInventory() {
		return this.inventory;
	}

	public int getCoilStatus() {
		return this.coilStatus;
	}

	public void setCoilStatus(final int coilStatus) {
		this.coilStatus = coilStatus;
	}

	public int getCrafingTickTime() {
		return this.crafingTickTime;
	}

	public void setCrafingTickTime(final int crafingTickTime) {
		this.crafingTickTime = crafingTickTime;
	}

	public int getFinalTickTime() {
		return this.finalTickTime;
	}

	public void setFinalTickTime(final int finalTickTime) {
		this.finalTickTime = finalTickTime;
	}

	public int getNeededPower() {
		return this.neededPower;
	}

	public void setNeededPower(final int neededPower) {
		this.neededPower = neededPower;
	}

	public int getProgressScaled() {
		return Math.max(0, Math.min(24, (this.getCrafingTickTime() > 0 ? 1 : 0)
				+ this.getCrafingTickTime() * 24 / (this.finalTickTime < 1 ? 1 : this.finalTickTime)));
	}

	@Override
	public BuiltContainer createContainer(final EntityPlayer player) {
		return new ContainerBuilder("fusionreactor").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142)
				.addInventory().tile(this).slot(0, 88, 17).slot(1, 88, 53).outputSlot(2, 148, 35).syncEnergyValue()
				.syncIntegerValue(this::getCoilStatus, this::setCoilStatus)
				.syncIntegerValue(this::getCrafingTickTime, this::setCrafingTickTime)
				.syncIntegerValue(this::getFinalTickTime, this::setFinalTickTime)
				.syncIntegerValue(this::getNeededPower, this::setNeededPower).addInventory().create();
	}
}
