package techreborn.tiles.generator;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipeList;
import techreborn.api.generator.GeneratorRecipeHelper;

public abstract class TileBaseFluidGenerator extends TilePowerAcceptor implements IWrenchable, IInventoryProvider {

	private final FluidGeneratorRecipeList recipes;

	private final int euTick;

	public final Tank tank;
	public final Inventory inventory;

	/*
	 * We use this to keep track of fractional millibuckets, allowing us to hit
	 * our eu/bucket targets while still only ever removing integer millibucket
	 * amounts.
	 */
	double pendingWithdraw = 0.0;

	public TileBaseFluidGenerator(EFluidGenerator type, int tier, String tileName, int tankCapacity, int euTick) {
		super(tier);

		recipes = GeneratorRecipeHelper.getFluidRecipesForGenerator(type);

		tank = new Tank(tileName, tankCapacity, this);
		inventory = new Inventory(3, tileName, 64, this);
		this.euTick = euTick;
	}

	public TileBaseFluidGenerator(EFluidGenerator type, EnumPowerTier tier, String tileName, int tankCapacity,
			int euTick) {
		this(type, tier.ordinal(), tileName, tankCapacity, euTick);
	}

	protected long lastOutput = 0;

	@Override
	public void updateEntity() {
		super.updateEntity();

		if (!this.field_145850_b.field_72995_K) {
			if ((this.acceptFluid() && FluidUtils.drainContainers(this.tank, this.inventory, 0, 1))
					|| FluidUtils.fillContainers(tank, inventory, 0, 1, tank.getFluidType()))
				this.syncWithAll();
		}

		if (this.tank.getFluidAmount() > 0) {
			this.getRecipes().getRecipeForFluid(tank.getFluidType()).ifPresent(recipe -> {

				if(tryAddingEnergy(euTick))
				{
					final Integer euPerBucket = recipe.getEnergyPerMb() * 1000;
					final float millibucketsPerTick = 16000f / (float) euPerBucket;
					this.pendingWithdraw += millibucketsPerTick;

					final int currentWithdraw = (int) this.pendingWithdraw;
					
					this.pendingWithdraw -= currentWithdraw;

					this.tank.drain(currentWithdraw, true);
					
					this.lastOutput = this.field_145850_b.func_82737_E();
				}
			});
		}

		if (this.tank.getFluidType() != null && this.func_70301_a(2) == null)
			this.inventory.func_70299_a(2, new ItemStack(this.tank.getFluidType().getBlock()));
		else if (this.tank.getFluidType() == null && this.func_70301_a(2) != null)
			this.func_70299_a(2, null);

		if (!this.field_145850_b.field_72995_K) {
			if (this.field_145850_b.func_82737_E() - this.lastOutput < 30 && !this.isActive())
				this.field_145850_b.func_175656_a(this.func_174877_v(),
						this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BlockMachineBase.ACTIVE, true));
			else if (this.field_145850_b.func_82737_E() - this.lastOutput > 30 && this.isActive())
				this.field_145850_b.func_175656_a(this.func_174877_v(),
						this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BlockMachineBase.ACTIVE, false));
		}
	}

	protected boolean tryAddingEnergy(int amount) {
		if (this.getMaxPower() - this.getEnergy() >= amount) {
			addEnergy(amount);
			return true;
		} else if (this.getMaxPower() - this.getEnergy() > 0) {
			addEnergy(this.getMaxPower() - this.getEnergy());
			return true;
		}
		return false;
	}

	protected boolean acceptFluid() {
		if (this.func_70301_a(0) != null) {
			FluidStack stack = FluidUtils.getFluidStackInContainer(this.func_70301_a(0));
			if (stack != null)
				return recipes.getRecipeForFluid(stack.getFluid()).isPresent();
		}
		return false;
	}

	public FluidGeneratorRecipeList getRecipes() {
		return recipes;
	}

	@Override
	public double getMaxOutput() {
		return euTick;
	}

	@Override
	public double getMaxInput() {
		return 0;
	}

	@Override
	public EnumPowerTier getTier() {
		return EnumPowerTier.values()[this.tier];
	}

	@Override
	public boolean canAcceptEnergy(EnumFacing direction) {
		return false;
	}

	@Override
	public boolean canProvideEnergy(EnumFacing direction) {
		return true;
	}

	@Override
	public Inventory getInventory() {
		return inventory;
	}

	@Override
	public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
		if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
			return true;
		}
		return super.hasCapability(capability, facing);
	}

	@Override
	public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
		if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
			return (T) tank;
		}
		return super.getCapability(capability, facing);
	}

	@Override
	public void func_145839_a(NBTTagCompound tagCompound) {
		super.func_145839_a(tagCompound);
		tank.readFromNBT(tagCompound);
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
		super.func_189515_b(tagCompound);
		tank.writeToNBT(tagCompound);
		return tagCompound;
	}

	@Override
	public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
		field_145850_b.func_147458_c(func_174877_v().func_177958_n(), func_174877_v().func_177956_o(), func_174877_v().func_177952_p(), func_174877_v().func_177958_n(),
				func_174877_v().func_177956_o(), func_174877_v().func_177952_p());
		func_145839_a(packet.func_148857_g());
	}

	@Override
	public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
		return false;
	}

	@Override
	public EnumFacing getFacing() {
		return getFacingEnum();
	}

	@Override
	public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
		return entityPlayer.func_70093_af();
	}

	@Override
	public float getWrenchDropRate() {
		return 1.0F;
	}
}
