package techreborn.tiles.generator;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;

public class TileHeatGenerator extends TilePowerAcceptor implements IWrenchable {

	public static final int euTick = ConfigTechReborn.HeatGeneratorOutput;

	public TileHeatGenerator() {
		super(1);
	}
	
	private long lastOutput = 0;

	@Override
	public void updateEntity() {
		super.updateEntity();

		if (!field_145850_b.field_72995_K) {
			for (final EnumFacing direction : EnumFacing.values()) {
				if(direction.equals(EnumFacing.UP))
					continue;
				if (this.field_145850_b
						.func_180495_p(new BlockPos(this.func_174877_v().func_177958_n() + direction.func_82601_c(),
								this.func_174877_v().func_177956_o() + direction.func_96559_d(),
								this.func_174877_v().func_177952_p() + direction.func_82599_e()))
						.func_177230_c() == Blocks.field_150353_l) {
					if(tryAddingEnergy(euTick))
						this.lastOutput = this.field_145850_b.func_82737_E();
				}
			}

			if (this.field_145850_b.func_82737_E() - this.lastOutput < 30 && !this.isActive())
				this.field_145850_b.func_175656_a(this.func_174877_v(),
						this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BlockMachineBase.ACTIVE, true));
			else if (this.field_145850_b.func_82737_E() - this.lastOutput > 30 && this.isActive())
				this.field_145850_b.func_175656_a(this.func_174877_v(),
						this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BlockMachineBase.ACTIVE, false));
		}
	}
	
	private boolean tryAddingEnergy(int amount)
	{
		if(this.getMaxPower() - this.getEnergy() >= amount)
		{
			addEnergy(amount);
			return true;
		}
		else if(this.getMaxPower() - this.getEnergy() > 0)
		{
			addEnergy(this.getMaxPower() - this.getEnergy());
			return true;
		}
		return false;
	}

	@Override
	public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
		return false;
	}

	@Override
	public EnumFacing getFacing() {
		return getFacingEnum();
	}

	@Override
	public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
		return entityPlayer.func_70093_af();
	}

	@Override
	public float getWrenchDropRate() {
		return 1.0F;
	}

	@Override
	public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
		return new ItemStack(ModBlocks.HEAT_GENERATOR, 1);
	}

	public boolean isComplete() {
		return false;
	}

	@Override
	public double getMaxPower() {
		return 10000;
	}

	@Override
	public boolean canAcceptEnergy(EnumFacing direction) {
		return false;
	}

	@Override
	public boolean canProvideEnergy(EnumFacing direction) {
		return true;
	}

	@Override
	public double getMaxOutput() {
		return 64;
	}

	@Override
	public double getMaxInput() {
		return 0;
	}

	@Override
	public EnumPowerTier getTier() {
		return EnumPowerTier.LOW;
	}

	// @Override
	// public void addWailaInfo(List<String> info)
	// {
	// super.addWailaInfo(info);
	// info.add("Power Generarating " + euTick +" EU/t");
	//
	// }

}
