package techreborn.tiles.generator;

import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import techreborn.config.ConfigTechReborn;

public class TileLightningRod extends TilePowerAcceptor {

	private int onStatusHoldTicks = -1;

	public TileLightningRod() {
		super(2);
	}

	@Override
	public void func_73660_a() {
		super.func_73660_a();

		if (onStatusHoldTicks > 0)
			--onStatusHoldTicks;

		if (onStatusHoldTicks == 0 || getEnergy() <= 0) {
			if (func_145838_q() instanceof BlockMachineBase)
				((BlockMachineBase) func_145838_q()).setActive(false, field_145850_b, field_174879_c);
			onStatusHoldTicks = -1;
		}

		float weatherStrength = field_145850_b.func_72819_i(1.0F);
		if (weatherStrength > 0.2F) {
			//lightStrikeChance = (MAX - (CHANCE * WEATHER_STRENGTH)
			float lightStrikeChance = ((100F - ConfigTechReborn.LightningRodChance) * 20F);
			float totalChance = lightStrikeChance * getLightningStrikeMultiplier() * ((1.1F - weatherStrength));
			if (field_145850_b.field_73012_v.nextInt((int) Math.floor(totalChance)) == 0) {
				EntityLightningBolt lightningBolt = new EntityLightningBolt(field_145850_b,
					field_174879_c.func_177958_n() + 0.5F,
					field_145850_b.field_73011_w.func_76557_i(),
					field_174879_c.func_177952_p() + 0.5F, false);
				field_145850_b.func_72942_c(lightningBolt);
				field_145850_b.func_72838_d(lightningBolt);
				addEnergy(32768 * (0.3F + weatherStrength));
				((BlockMachineBase) func_145838_q()).setActive(true, field_145850_b, field_174879_c);
				onStatusHoldTicks = 400;
			}
		}

	}

	public float getLightningStrikeMultiplier() {
		float actualHeight = field_145850_b.field_73011_w.getActualHeight();
		float groundLevel = field_145850_b.field_73011_w.func_76557_i();
		for (int i = field_174879_c.func_177956_o() + 1; i < actualHeight; i++) {
			if (!isValidIronFence(i)) {
				if (groundLevel >= i)
					return 4.3F;
				float max = actualHeight - groundLevel;
				float got = i - groundLevel;
				return 1.2F - got / max;
			}
		}
		return 4F;
	}

	public boolean isValidIronFence(int y) {
		Item itemBlock = Item.func_150898_a(field_145850_b.func_180495_p(new BlockPos(field_174879_c.func_177958_n(), y, field_174879_c.func_177952_p())).func_177230_c());
		for (ItemStack fence : OreDictionary.getOres("fenceIron")) {
			if (fence.func_77973_b() == itemBlock)
				return true;
		}
		return false;
	}

	@Override
	public double getMaxPower() {
		return 327680;
	}

	@Override
	public boolean canAcceptEnergy(EnumFacing direction) {
		return false;
	}

	@Override
	public boolean canProvideEnergy(EnumFacing direction) {
		return direction == getFacingEnum();
	}

	@Override
	public double getMaxOutput() {
		return 2048;
	}

	@Override
	public double getMaxInput() {
		return 0;
	}

	@Override
	public EnumPowerTier getTier() {
		return EnumPowerTier.HIGH;
	}

}
