package techreborn.tiles.generator;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.TilePowerAcceptor;
import techreborn.blocks.generator.BlockSolarPanel;

import java.util.List;

/**
 * Created by modmuss50 on 25/02/2016.
 */
public class TileSolarPanel extends TilePowerAcceptor implements ITickable {

	boolean shouldMakePower = false;
	boolean lastTickSate = false;

	int powerToAdd;

	public TileSolarPanel() {
		super(1);
	}

	@Override
	public void updateEntity() {
		super.updateEntity();
		if (!field_145850_b.field_72995_K) {
			if (field_145850_b.func_82737_E() % 60 == 0) {
				shouldMakePower = isSunOut();

			}
			if (shouldMakePower) {
				powerToAdd = 10;
				addEnergy(powerToAdd);
			} else {
				powerToAdd = 0;
			}

			field_145850_b.func_175656_a(func_174877_v(),
				field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BlockSolarPanel.ACTIVE, isSunOut()));
		}
	}

	@Override
	public void addInfo(List<String> info, boolean isRealTile) {
		super.addInfo(info, isRealTile);
		if (isRealTile) {
			// FIXME: 25/02/2016
			// info.add(TextFormatting.LIGHT_PURPLE + "Power gen/tick " +
			// TextFormatting.GREEN + PowerSystem.getLocaliszedPower(
			// powerToAdd)) ;
		}
	}

	public boolean isSunOut() {
		return field_145850_b.func_175710_j(field_174879_c.func_177984_a()) && !field_145850_b.func_72896_J() && !field_145850_b.func_72911_I()
			&& field_145850_b.func_72935_r();
	}

	@Override
	public double getMaxPower() {
		return 1000;
	}

	@Override
	public boolean canAcceptEnergy(EnumFacing direction) {
		return false;
	}

	@Override
	public boolean canProvideEnergy(EnumFacing direction) {
		return true;
	}

	@Override
	public double getMaxOutput() {
		return 32;
	}

	@Override
	public double getMaxInput() {
		return 0;
	}

	@Override
	public EnumPowerTier getTier() {
		return EnumPowerTier.LOW;
	}
}
