package techreborn.tiles.generator;

import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.TilePowerAcceptor;

/**
 * Created by modmuss50 on 25/02/2016.
 */
public class TileWindMill extends TilePowerAcceptor {

	int basePower = 16;

	public TileWindMill() {
		super(2);
	}

	@Override
	public void updateEntity() {
		super.updateEntity();
		if (field_174879_c.func_177956_o() > 64) {
			int actualPower = basePower;
			if (field_145850_b.func_72911_I()) {
				actualPower *= 1.25;
			}
			addEnergy(actualPower); // Value taken from
			// http://wiki.industrial-craft.net/?title=Wind_Mill
			// Not worth making more complicated
		}
	}

	@Override
	public double getMaxPower() {
		return 10000;
	}

	@Override
	public boolean canAcceptEnergy(EnumFacing direction) {
		return false;
	}

	@Override
	public boolean canProvideEnergy(EnumFacing direction) {
		return true;
	}

	@Override
	public double getMaxOutput() {
		return 128;
	}

	@Override
	public double getMaxInput() {
		return 0;
	}

	@Override
	public EnumPowerTier getTier() {
		return EnumPowerTier.LOW;
	}
}
