package techreborn.tiles.lesu;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.common.tile.TileLegacyMachineBase;

public class TileLesuStorage extends TileLegacyMachineBase {

	public LesuNetwork network;

	@Override
	public void updateEntity() {
		super.updateEntity();
		if (network == null) {
			findAndJoinNetwork(field_145850_b, func_174877_v().func_177958_n(), func_174877_v().func_177956_o(), func_174877_v().func_177952_p());
		} else {
			if (network.master != null
				&& network.master.func_145831_w().func_175625_s(new BlockPos(network.master.func_174877_v().func_177958_n(),
				network.master.func_174877_v().func_177956_o(), network.master.func_174877_v().func_177952_p())) != network.master) {
				network.master = null;
			}
		}
	}

	public final void findAndJoinNetwork(World world, int x, int y, int z) {
		network = new LesuNetwork();
		network.addElement(this);
		for (EnumFacing direction : EnumFacing.values()) {
			if (world.func_175625_s(new BlockPos(x + direction.func_82601_c(), y + direction.func_96559_d(),
				z + direction.func_82599_e())) instanceof TileLesuStorage) {
				TileLesuStorage lesu = (TileLesuStorage) world
					.func_175625_s(new BlockPos(x + direction.func_82601_c(), y + direction.func_96559_d(),
						z + direction.func_82599_e()));
				if (lesu.network != null) {
					lesu.network.merge(network);
				}
			}
		}
	}

	public final void setNetwork(LesuNetwork n) {
		if (n == null) {
		} else {
			network = n;
			network.addElement(this);
		}
	}

	public final void resetNetwork() {
		network = null;
	}

	public final void removeFromNetwork() {
		if (network == null) {
		} else
			network.removeElement(this);
	}

	public final void rebuildNetwork() {
		this.removeFromNetwork();
		this.resetNetwork();
		this.findAndJoinNetwork(field_145850_b, func_174877_v().func_177958_n(), func_174877_v().func_177956_o(), func_174877_v().func_177952_p());
	}
}
