package techreborn.tiles.teir1;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumFacing;

import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;

import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;

public class TileElectricFurnace extends TilePowerAcceptor
		implements IWrenchable, IInventoryProvider, IContainerProvider {

	public Inventory inventory = new Inventory(6, "TileElectricFurnace", 64, this);
	public int capacity = 1000;
	public int progress;
	public int fuelScale = 100;
	public int cost = 8;
	int input1 = 0;
	int output = 1;

	public TileElectricFurnace() {
		super(1);
	}

	public int gaugeProgressScaled(final int scale) {
		return this.progress * scale / this.fuelScale;
	}

	@Override
	public void func_73660_a() {
		if (!this.field_145850_b.field_72995_K) {
			super.func_73660_a();

			final boolean burning = this.isBurning();
			boolean updateInventory = false;
			if (this.isBurning() && this.canSmelt()) {
				this.updateState();

				this.progress++;
				if (this.progress % 10 == 0) {
					this.useEnergy(this.cost);
				}
				if (this.progress >= this.fuelScale) {
					this.progress = 0;
					this.cookItems();
					updateInventory = true;
				}
			} else {
				this.progress = 0;
				this.updateState();
			}
			if (burning != this.isBurning()) {
				updateInventory = true;
			}
			if (updateInventory) {
				this.func_70296_d();
			}
		}
	}

	public void cookItems() {
		if (this.canSmelt()) {
			final ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));

			if (this.func_70301_a(this.output) == null) {
				this.func_70299_a(this.output, itemstack.func_77946_l());
			} else if (this.func_70301_a(this.output).func_77969_a(itemstack)) {
				this.func_70301_a(this.output).field_77994_a += (itemstack.field_77994_a);
			}
			if (this.func_70301_a(this.input1).field_77994_a > 1) {
				this.func_70298_a(this.input1, 1);
			} else {
				this.func_70299_a(this.input1, null);
			}
		}
	}

	public boolean canSmelt() {
		if (this.func_70301_a(this.input1) == null) {
			return false;
		}
		final ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));
		if (itemstack == null)
			return false;
		if (this.func_70301_a(this.output) == null)
			return true;
		if (!this.func_70301_a(this.output).func_77969_a(itemstack))
			return false;
		final int result = this.func_70301_a(this.output).field_77994_a + itemstack.field_77994_a;
		return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
	}

	public boolean isBurning() {
		return this.getEnergy() > this.cost;
	}

	public ItemStack getResultFor(final ItemStack stack) {
		final ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
		if (result != null) {
			return result.func_77946_l();
		}
		return null;
	}

	public void updateState() {
		final IBlockState BlockStateContainer = this.field_145850_b.func_180495_p(this.field_174879_c);
		if (BlockStateContainer.func_177230_c() instanceof BlockMachineBase) {
			final BlockMachineBase blockMachineBase = (BlockMachineBase) BlockStateContainer.func_177230_c();
			if (BlockStateContainer.func_177229_b(BlockMachineBase.ACTIVE) != this.progress > 0)
				blockMachineBase.setActive(this.progress > 0, this.field_145850_b, this.field_174879_c);
		}
	}

	@Override
	public boolean wrenchCanSetFacing(final EntityPlayer entityPlayer, final EnumFacing side) {
		return false;
	}

	@Override
	public EnumFacing getFacing() {
		return this.getFacingEnum();
	}

	@Override
	public boolean wrenchCanRemove(final EntityPlayer entityPlayer) {
		return entityPlayer.func_70093_af();
	}

	@Override
	public float getWrenchDropRate() {
		return 1.0F;
	}

	@Override
	public ItemStack getWrenchDrop(final EntityPlayer entityPlayer) {
		return new ItemStack(ModBlocks.ELECTRIC_FURNACE, 1);
	}

	public boolean isComplete() {
		return false;
	}

	// ISidedInventory
	@Override
	public int[] func_180463_a(final EnumFacing side) {
		if (side.equals(EnumFacing.UP))
			return new int[] { 0 };
		else if (side.equals(EnumFacing.DOWN))
			return new int[] { 1 };
		return new int[0];
	}

	@Override
	public boolean func_180462_a(final int slotIndex, final ItemStack itemStack, final EnumFacing side) {
		if (slotIndex == 2)
			return false;
		return this.func_94041_b(slotIndex, itemStack);
	}

	@Override
	public boolean func_180461_b(final int slotIndex, final ItemStack itemStack, final EnumFacing side) {
		return slotIndex == 1;
	}

	@Override
	public double getMaxPower() {
		return this.capacity;
	}

	@Override
	public boolean canAcceptEnergy(final EnumFacing direction) {
		return true;
	}

	@Override
	public boolean canProvideEnergy(final EnumFacing direction) {
		return false;
	}

	@Override
	public double getMaxOutput() {
		return 0;
	}

	@Override
	public double getMaxInput() {
		return 32;
	}

	@Override
	public EnumPowerTier getTier() {
		return EnumPowerTier.LOW;
	}

	@Override
	public Inventory getInventory() {
		return this.inventory;
	}

	public int getBurnTime() {
		return this.progress;
	}

	public void setBurnTime(final int burnTime) {
		this.progress = burnTime;
	}

	@Override
	public BuiltContainer createContainer(final EntityPlayer player) {
		return new ContainerBuilder("electricfurnace").player(player.field_71071_by).inventory().hotbar().addInventory()
				.tile(this).slot(0, 55, 45).outputSlot(1, 101, 45).syncEnergyValue()
				.syncIntegerValue(this::getBurnTime, this::setBurnTime).addInventory().create();
	}
}
