package techreborn.tiles.teir1;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;
import techreborn.items.ItemParts;

public class TileRecycler extends TilePowerAcceptor implements IWrenchable, IInventoryProvider, IContainerProvider {

	private final Inventory inventory = new Inventory(6, "TileRecycler", 64, this);
	private final int capacity = 1000;
	private final int cost = 2;
	private final int time = 15;
	private final int chance = 6;
	private boolean isBurning;
	private int progress;

	public TileRecycler() {
		super(1);
	}

	public int gaugeProgressScaled(final int scale) {
		return this.progress * scale / this.time;
	}

	@Override
	public void updateEntity() {
		if (this.field_145850_b.field_72995_K)
			return;

		boolean updateInventory = false;
		if (this.canRecycle() && !this.isBurning() && this.getEnergy() != 0)
			this.setBurning(true);
		else if (this.isBurning()) {
			if (this.useEnergy(this.cost) != this.cost)
				this.setBurning(false);
			this.progress++;
			if (this.progress >= this.time) {
				this.progress = 0;
				this.recycleItems();
				updateInventory = true;
				this.setBurning(false);
			}
		}

		this.updateState();

		if (updateInventory) {
			this.func_70296_d();
		}
	}

	public void recycleItems() {
		final ItemStack itemstack = ItemParts.getPartByName("scrap");
		final int randomchance = this.field_145850_b.field_73012_v.nextInt(this.chance);

		if (randomchance == 1) {
			if (this.func_70301_a(1) == null)
				this.func_70299_a(1, itemstack.func_77946_l());
			else
				this.func_70301_a(1).field_77994_a += (itemstack.field_77994_a);
		}
		this.func_70298_a(0, 1);
	}

	public boolean canRecycle() {
		return this.func_70301_a(0) != null && this.hasSlotGotSpace(1);
	}

	public boolean hasSlotGotSpace(final int slot) {
		if (this.func_70301_a(slot) == null) {
			return true;
		} else if (this.func_70301_a(slot).field_77994_a < this.func_70301_a(slot).func_77976_d()) {
			return true;
		}
		return true;
	}

	public boolean isBurning() {
		return this.isBurning;
	}

	public void setBurning(final boolean burning) {
		this.isBurning = burning;
	}

	public void updateState() {
		final IBlockState BlockStateContainer = this.field_145850_b.func_180495_p(this.field_174879_c);
		if (BlockStateContainer.func_177230_c() instanceof BlockMachineBase) {
			final BlockMachineBase blockMachineBase = (BlockMachineBase) BlockStateContainer.func_177230_c();
			if (BlockStateContainer.func_177229_b(BlockMachineBase.ACTIVE) != this.isBurning)
				blockMachineBase.setActive(this.isBurning, this.field_145850_b, this.field_174879_c);
		}
	}

	@Override
	public boolean wrenchCanSetFacing(final EntityPlayer entityPlayer, final EnumFacing side) {
		return false;
	}

	@Override
	public EnumFacing getFacing() {
		return this.getFacingEnum();
	}

	@Override
	public boolean wrenchCanRemove(final EntityPlayer entityPlayer) {
		return entityPlayer.func_70093_af();
	}

	@Override
	public float getWrenchDropRate() {
		return 1.0F;
	}

	@Override
	public ItemStack getWrenchDrop(final EntityPlayer entityPlayer) {
		return new ItemStack(ModBlocks.RECYCLER, 1);
	}

	public boolean isComplete() {
		return false;
	}

	// ISidedInventory
	@Override
	public int[] func_180463_a(final EnumFacing side) {
		if (side.equals(EnumFacing.UP))
			return new int[] { 0 };
		else if (side.equals(EnumFacing.DOWN))
			return new int[] { 1 };
		return new int[0];
	}

	@Override
	public boolean func_180462_a(final int slotIndex, final ItemStack itemStack, final EnumFacing side) {
		if (slotIndex == 1)
			return false;
		return this.func_94041_b(slotIndex, itemStack);
	}

	@Override
	public boolean func_180461_b(final int slotIndex, final ItemStack itemStack, final EnumFacing side) {
		return slotIndex == 1;
	}

	@Override
	public double getMaxPower() {
		return this.capacity;
	}

	@Override
	public boolean canAcceptEnergy(final EnumFacing direction) {
		return true;
	}

	@Override
	public boolean canProvideEnergy(final EnumFacing direction) {
		return false;
	}

	@Override
	public double getMaxOutput() {
		return 0;
	}

	@Override
	public double getMaxInput() {
		return 32;
	}

	@Override
	public EnumPowerTier getTier() {
		return EnumPowerTier.MEDIUM;
	}

	@Override
	public Inventory getInventory() {
		return this.inventory;
	}

	public int getProgress() {
		return this.progress;
	}

	public void setProgress(final int progress) {
		this.progress = progress;
	}

	@Override
	public BuiltContainer createContainer(final EntityPlayer player) {
		return new ContainerBuilder("recycler").player(player.field_71071_by).inventory().hotbar().addInventory()
			.tile(this).slot(0, 55, 45).slot(1, 101, 45).syncEnergyValue()
			.syncIntegerValue(this::getProgress, this::setProgress).addInventory().create();
	}
}
