package techreborn.utils;

import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import techreborn.init.ModBlocks;

import java.util.ArrayList;

/**
 * Created by Mark on 23/03/2016.
 */
public class StackWIPHandler {
	ArrayList<Block> wipBlocks = new ArrayList<>();
	public static ArrayList<ItemStack> devHeads = new ArrayList<>();

	public StackWIPHandler() {
		wipBlocks.add(ModBlocks.MAGICAL_ABSORBER);
		wipBlocks.add(ModBlocks.CHUNK_LOADER);
		wipBlocks.add(ModBlocks.CHARGE_O_MAT);
		wipBlocks.add(ModBlocks.MAGIC_ENERGY_CONVERTER);

		addHead("modmuss50");
		addHead("Gigabit101");
		addHead("ProfProspector");
		addHead("Rushmead");
	}

	private void addHead(String name) {
		ItemStack head = new ItemStack(Items.field_151144_bL, 1, 3);
		head.func_77982_d(new NBTTagCompound());
		head.func_77978_p().func_74782_a("SkullOwner", new NBTTagString(name));
		devHeads.add(head);
	}

	@SubscribeEvent
	public void toolTip(ItemTooltipEvent event) {
		Block block = Block.func_149634_a(event.getItemStack().func_77973_b());
		if (block != null && wipBlocks.contains(block)) {
			event.getToolTip().add(TextFormatting.RED + "WIP Coming Soon");
		}

		if (devHeads.contains(event.getItemStack())) {
			event.getToolTip().add(TextFormatting.GOLD + "TechReborn Developer");
		}
	}
}
