/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.util.CraftingHelper;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.OreUtil;
import reborncore.common.util.StringUtils;
import techreborn.Core;
import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.api.recipe.machines.AlloySmelterRecipe;
import techreborn.api.recipe.machines.BlastFurnaceRecipe;
import techreborn.api.recipe.machines.ChemicalReactorRecipe;
import techreborn.api.recipe.machines.CompressorRecipe;
import techreborn.api.recipe.machines.GrinderRecipe;
import techreborn.api.recipe.machines.VacuumFreezerRecipe;
import techreborn.blocks.BlockMachineFrame;
import techreborn.blocks.BlockOre;
import techreborn.compat.CompatManager;
import techreborn.config.ConfigTechReborn;
import techreborn.init.IC2Duplicates;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.init.recipes.CraftingTableRecipes;
import techreborn.init.recipes.ExtractorRecipes;
import techreborn.init.recipes.FluidGeneratorRecipes;
import techreborn.init.recipes.ImplosionCompressorRecipes;
import techreborn.init.recipes.IndustrialCentrifugeRecipes;
import techreborn.init.recipes.IndustrialElectrolyzerRecipes;
import techreborn.init.recipes.IndustrialGrinderRecipes;
import techreborn.init.recipes.RollingMachineRecipes;
import techreborn.init.recipes.ScrapboxRecipes;
import techreborn.init.recipes.SmeltingRecipes;
import techreborn.items.ItemCells;
import techreborn.items.ItemDusts;
import techreborn.items.ItemDustsSmall;
import techreborn.items.ItemIngots;
import techreborn.items.ItemParts;
import techreborn.items.ItemPlates;
import techreborn.items.ItemUpgrades;
import techreborn.utils.OreDictUtils;

public class ModRecipes {
    public static ConfigTechReborn config;

    public static void init() {
        OreUtil.scanForOres();
        CompatManager.isQuantumStorageLoaded = Loader.isModLoaded((String)"quantumstorage");
        CraftingTableRecipes.init();
        SmeltingRecipes.init();
        ExtractorRecipes.init();
        RollingMachineRecipes.init();
        FluidGeneratorRecipes.init();
        IndustrialGrinderRecipes.init();
        IndustrialCentrifugeRecipes.init();
        IndustrialElectrolyzerRecipes.init();
        ImplosionCompressorRecipes.init();
        ScrapboxRecipes.init();
        ModRecipes.addGeneralShapedRecipes();
        ModRecipes.addMachineRecipes();
        ModRecipes.addAlloySmelterRecipes();
        ModRecipes.addChemicalReactorRecipes();
        ModRecipes.addBlastFurnaceRecipes();
        ModRecipes.addVacuumFreezerRecipes();
        ModRecipes.addReactorRecipes();
        ModRecipes.addIc2Recipes();
        ModRecipes.addGrinderRecipes();
        ModRecipes.addCompressorRecipes();
    }

    public static void postInit() {
        if (ConfigTechReborn.disableRailcraftSteelNuggetRecipe) {
            Iterator iterator = FurnaceRecipes.func_77602_a().func_77599_b().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!(entry.getValue() instanceof ItemStack) || !(entry.getKey() instanceof ItemStack)) continue;
                ItemStack input = (ItemStack)entry.getKey();
                ItemStack output = (ItemStack)entry.getValue();
                if (!ItemUtils.isInputEqual((Object)"nuggetSteel", (ItemStack)output, (boolean)true, (boolean)true, (boolean)false) || !ItemUtils.isInputEqual((Object)"nuggetIron", (ItemStack)input, (boolean)true, (boolean)true, (boolean)false)) continue;
                Core.logHelper.info((Object)"Removing a steelnugget smelting recipe");
                iterator.remove();
            }
        }
    }

    private static void addCompressorRecipes() {
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(ItemIngots.getIngotByName("advanced_alloy"), ItemPlates.getPlateByName("advanced_alloy"), 400, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(IC2Duplicates.CARBON_MESH.getStackBasedOnConfig(), ItemPlates.getPlateByName("carbon"), 400, 2));
        for (String ore : OreUtil.oreNames) {
            if (OreUtil.doesOreExistAndValid((String)("plate" + OreUtil.capitalizeFirstLetter((String)ore))) && OreUtil.doesOreExistAndValid((String)("ingot" + OreUtil.capitalizeFirstLetter((String)ore)))) {
                RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)("ingot" + OreUtil.capitalizeFirstLetter((String)ore)), (int)9), OreUtil.getStackFromName((String)("plate" + OreUtil.capitalizeFirstLetter((String)ore)), (int)1), 300, 4));
            }
            if (OreUtil.doesOreExistAndValid((String)("plate" + OreUtil.capitalizeFirstLetter((String)ore))) && OreUtil.doesOreExistAndValid((String)("gem" + OreUtil.capitalizeFirstLetter((String)ore)))) {
                RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)("gem" + OreUtil.capitalizeFirstLetter((String)ore)), (int)9), OreUtil.getStackFromName((String)("plate" + OreUtil.capitalizeFirstLetter((String)ore)), (int)1), 300, 4));
            }
            if (!OreUtil.hasPlate((String)ore) || !OreUtil.hasBlock((String)ore)) continue;
            RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)("block" + OreUtil.capitalizeFirstLetter((String)ore)), (int)1), OreUtil.getStackFromName((String)("plate" + OreUtil.capitalizeFirstLetter((String)ore)), (int)1), 300, 4));
        }
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)"plankWood", (int)1), OreUtil.getStackFromName((String)"plateWood", (int)1), 300, 4));
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)"dustLazurite", (int)8), OreUtil.getStackFromName((String)"plateLazurite", (int)1), 300, 4));
    }

    static void addGrinderRecipes() {
        int eutick = 2;
        int ticktime = 300;
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151100_aR, 6, 15), 170, 19));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.field_150347_e), new ItemStack((Block)Blocks.field_150354_m), 230, 23));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.field_150351_n), new ItemStack(Items.field_151145_ak), 200, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.field_150424_aL), ItemDusts.getDustByName("netherrack"), 300, 27));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.field_151044_h), ItemDusts.getDustByName("coal"), 300, 27));
        for (String oreDictionaryName : OreDictionary.getOreNames()) {
            if (!OreDictUtils.isDictPrefixed(oreDictionaryName, "ore", "gem", "ingot")) continue;
            ItemStack oreStack = OreDictUtils.getDictOreOrEmpty(oreDictionaryName, 1);
            String[] data = OreDictUtils.getDictData(oreDictionaryName);
            if (data[0].equals("ore") && (data[1].equals("tungsten") || data[1].equals("titanium") || data[1].equals("aluminium") || data[1].equals("iridium") || data[1].equals("saltpeter")) || oreStack == null) continue;
            boolean ore = data[0].equals("ore");
            Core.logHelper.debug((Object)("Ore: " + data[1]));
            ItemStack dust = OreDictUtils.getDictOreOrEmpty(OreDictUtils.joinDictName("dust", data[1]), ore ? 2 : 1);
            if (dust == null || dust.func_77973_b() == null) continue;
            dust = dust.func_77946_l();
            if (ore) {
                dust.field_77994_a = 2;
            }
            RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(oreStack, dust, ore ? 270 : 200, ore ? 31 : 22));
        }
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.field_151044_h), ItemDusts.getDustByName("coal"), 120, 10));
    }

    static void addReactorRecipes() {
        FusionReactorRecipeHelper.registerRecipe(new FusionReactorRecipe(ItemCells.getCellByName("helium3"), ItemCells.getCellByName("deuterium"), ItemCells.getCellByName("heliumplasma"), 4.0E7, 32768.0, 1024));
        FusionReactorRecipeHelper.registerRecipe(new FusionReactorRecipe(ItemCells.getCellByName("tritium"), ItemCells.getCellByName("deuterium"), ItemCells.getCellByName("helium3"), 6.0E7, 32768.0, 2048));
        FusionReactorRecipeHelper.registerRecipe(new FusionReactorRecipe(ItemCells.getCellByName("wolframium"), ItemCells.getCellByName("Berylium"), ItemDusts.getDustByName("platinum"), 8.0E7, -2048.0, 1024));
        FusionReactorRecipeHelper.registerRecipe(new FusionReactorRecipe(ItemCells.getCellByName("wolframium"), ItemCells.getCellByName("lithium"), BlockOre.getOreByName("iridium"), 9.0E7, -2048.0, 1024));
    }

    static void addGeneralShapedRecipes() {
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.CLOAKING_DEVICE), (Object[])new Object[]{"CIC", "IOI", "CIC", Character.valueOf('C'), "ingotChrome", Character.valueOf('I'), "plateIridium", Character.valueOf('O'), new ItemStack(ModItems.LAPOTRONIC_ORB)});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.TREE_TAP), (Object[])new Object[]{" S ", "PPP", "P  ", Character.valueOf('S'), "stickWood", Character.valueOf('P'), "plankWood"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.ROCK_CUTTER), (Object[])new Object[]{"DT ", "DT ", "DCB", Character.valueOf('D'), "dustDiamond", Character.valueOf('T'), "ingotTitanium", Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), new ItemStack(ModItems.RE_BATTERY)});
        for (String part : ItemParts.types) {
            if (!part.endsWith("Gear")) continue;
            CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName(part), (Object[])new Object[]{" O ", "OIO", " O ", Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('O'), "ingot" + StringUtils.toFirstCapital((String)part.replace("Gear", ""))});
        }
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("heliumCoolantSimple"), (Object[])new Object[]{" T ", "TCT", " T ", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), ItemCells.getCellByName("helium", 1)});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("HeliumCoolantTriple"), (Object[])new Object[]{"TTT", "CCC", "TTT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), ItemParts.getPartByName("heliumCoolantSimple")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("HeliumCoolantSix"), (Object[])new Object[]{"THT", "TCT", "THT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), "ingotCopper", Character.valueOf('H'), ItemParts.getPartByName("HeliumCoolantTriple")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("NaKCoolantTriple"), (Object[])new Object[]{"TTT", "CCC", "TTT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), ItemParts.getPartByName("NaKCoolantSimple")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("NaKCoolantSix"), (Object[])new Object[]{"THT", "TCT", "THT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), "ingotCopper", Character.valueOf('H'), ItemParts.getPartByName("NaKCoolantTriple")});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.ADJUSTABLE_SU), (Object[])new Object[]{"LLL", "LCL", "LLL", Character.valueOf('L'), new ItemStack(ModItems.LAPOTRONIC_ORB), Character.valueOf('C'), new ItemStack(ModItems.ENERGY_CRYSTAL)});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.INTERDIMENSIONAL_SU), (Object[])new Object[]{"PAP", "ACA", "PAP", Character.valueOf('P'), ItemPlates.getPlateByName("iridium"), Character.valueOf('C'), new ItemStack(Blocks.field_150477_bB), Character.valueOf('A'), new ItemStack(ModBlocks.ADJUSTABLE_SU)});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.FUSION_CONTROL_COMPUTER), (Object[])new Object[]{"CCC", "PTP", "CCC", Character.valueOf('P'), new ItemStack(ModItems.ENERGY_CRYSTAL), Character.valueOf('T'), new ItemStack(ModBlocks.FUSION_COIL), Character.valueOf('C'), "circuitMaster"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.LIGHTNING_ROD), (Object[])new Object[]{"CAC", "ACA", "CAC", Character.valueOf('A'), new ItemStack(ModBlocks.MACHINE_CASINGS, 1, 2), Character.valueOf('S'), ItemParts.getPartByName("superConductor"), Character.valueOf('C'), "circuitMaster"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.FUSION_COIL), (Object[])new Object[]{"CSC", "NAN", "CRC", Character.valueOf('A'), new ItemStack(ModBlocks.MACHINE_CASINGS, 1, 2), Character.valueOf('N'), ItemParts.getPartByName("nichromeHeatingCoil"), Character.valueOf('C'), "circuitMaster", Character.valueOf('S'), ItemParts.getPartByName("superConductor"), Character.valueOf('R'), ItemParts.getPartByName("iridiumNeutronReflector")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("iridiumNeutronReflector"), (Object[])new Object[]{"PPP", "PIP", "PPP", Character.valueOf('P'), ItemParts.getPartByName("thickNeutronReflector"), Character.valueOf('I'), "ingotIridium"});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("thickNeutronReflector"), (Object[])new Object[]{" P ", "PCP", " P ", Character.valueOf('P'), ItemParts.getPartByName("neutronReflector"), Character.valueOf('C'), ItemCells.getCellByName("Berylium")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("neutronReflector"), (Object[])new Object[]{"TCT", "CPC", "TCT", Character.valueOf('T'), "dustTin", Character.valueOf('C'), "dustCoal", Character.valueOf('P'), "plateCopper"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.SCRAP_BOX), (Object[])new Object[]{"SSS", "SSS", "SSS", Character.valueOf('S'), ItemParts.getPartByName("scrap")});
        if (!IC2Duplicates.deduplicate()) {
            CraftingHelper.addShapedOreRecipe((ItemStack)ItemUpgrades.getUpgradeByName("Overclock"), (Object[])new Object[]{"TTT", "WCW", Character.valueOf('T'), ItemParts.getPartByName("CoolantSimple"), Character.valueOf('W'), IC2Duplicates.CABLE_ICOPPER.getStackBasedOnConfig(), Character.valueOf('C'), "circuitBasic"});
            CraftingHelper.addShapedOreRecipe((ItemStack)ItemUpgrades.getUpgradeByName("Overclock", 2), (Object[])new Object[]{" T ", "WCW", Character.valueOf('T'), ItemParts.getPartByName("heliumCoolantSimple"), Character.valueOf('W'), IC2Duplicates.CABLE_ICOPPER.getStackBasedOnConfig(), Character.valueOf('C'), "circuitBasic"});
            CraftingHelper.addShapedOreRecipe((ItemStack)ItemUpgrades.getUpgradeByName("Overclock", 2), (Object[])new Object[]{" T ", "WCW", Character.valueOf('T'), ItemParts.getPartByName("NaKCoolantSimple"), Character.valueOf('W'), IC2Duplicates.CABLE_ICOPPER.getStackBasedOnConfig(), Character.valueOf('C'), "circuitBasic"});
        }
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemUpgrades.getUpgradeByName("transformer"), (Object[])new Object[]{"GGG", "WTW", "GCG", Character.valueOf('G'), "blockGlass", Character.valueOf('W'), IC2Duplicates.CABLE_IGOLD.getStackBasedOnConfig(), Character.valueOf('C'), "circuitBasic", Character.valueOf('T'), IC2Duplicates.MVT.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemUpgrades.getUpgradeByName("energy_storage"), (Object[])new Object[]{"PPP", "WBW", "PCP", Character.valueOf('P'), "plankWood", Character.valueOf('W'), IC2Duplicates.CABLE_ICOPPER.getStackBasedOnConfig(), Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), ModItems.RE_BATTERY});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("CoolantSimple"), (Object[])new Object[]{" T ", "TWT", " T ", Character.valueOf('T'), "ingotTin", Character.valueOf('W'), "containerWater"});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("CoolantTriple"), (Object[])new Object[]{"TTT", "CCC", "TTT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), ItemParts.getPartByName("CoolantSimple")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("CoolantSix"), (Object[])new Object[]{"TCT", "TPT", "TCT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), ItemParts.getPartByName("CoolantTriple"), Character.valueOf('P'), ItemPlates.getPlateByName("copper")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("NaKCoolantSimple"), (Object[])new Object[]{"TST", "PCP", "TST", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), ItemParts.getPartByName("CoolantSimple"), Character.valueOf('S'), ItemCells.getCellByName("sodium"), Character.valueOf('P'), ItemCells.getCellByName("potassium")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("NaKCoolantSimple"), (Object[])new Object[]{"TPT", "SCS", "TPT", Character.valueOf('T'), "ingotTin", Character.valueOf('C'), ItemParts.getPartByName("CoolantSimple"), Character.valueOf('S'), ItemCells.getCellByName("sodium"), Character.valueOf('P'), ItemCells.getCellByName("potassium")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("dataControlCircuit"), (Object[])new Object[]{"ADA", "DID", "ADA", Character.valueOf('I'), "ingotIridium", Character.valueOf('A'), ItemParts.getPartByName("advancedCircuit"), Character.valueOf('D'), ItemParts.getPartByName("dataStorageCircuit")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("dataOrb"), (Object[])new Object[]{"DDD", "DSD", "DDD", Character.valueOf('D'), ItemParts.getPartByName("dataStorageCircuit"), Character.valueOf('S'), ItemParts.getPartByName("dataStorageCircuit")});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.ELECTRIC_TREE_TAP), (Object[])new Object[]{"TB", "  ", Character.valueOf('T'), new ItemStack(ModItems.TREE_TAP), Character.valueOf('B'), new ItemStack(ModItems.RE_BATTERY)});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.NANOSABER), (Object[])new Object[]{"DC ", "DC ", "GLG", Character.valueOf('L'), new ItemStack(ModItems.LAPOTRONIC_CRYSTAL), Character.valueOf('C'), ItemPlates.getPlateByName("carbon"), Character.valueOf('D'), "plateDiamond", Character.valueOf('G'), ItemDustsSmall.getSmallDustByName("glowstone")});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("diamondGrindingHead", 2), (Object[])new Object[]{"TST", "SBS", "TST", Character.valueOf('T'), "plateDiamond", Character.valueOf('S'), "plateSteel", Character.valueOf('B'), "blockDiamond"});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("coolantSimple", 2), (Object[])new Object[]{" T ", "TWT", " T ", Character.valueOf('T'), "ingotTin", Character.valueOf('W'), new ItemStack(Items.field_151131_as)});
        Core.logHelper.info((Object)"Shapped Recipes Added");
    }

    static void addMachineRecipes() {
        if (!CompatManager.isQuantumStorageLoaded) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.QUANTUM_TANK), (Object[])new Object[]{"EPE", "PCP", "EPE", Character.valueOf('P'), "ingotPlatinum", Character.valueOf('E'), "circuitAdvanced", Character.valueOf('C'), ModBlocks.QUANTUM_CHEST});
        }
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.DIGITAL_CHEST), (Object[])new Object[]{"PPP", "PDP", "PCP", Character.valueOf('P'), "plateAluminum", Character.valueOf('D'), ItemParts.getPartByName("dataOrb"), Character.valueOf('C'), ItemParts.getPartByName("computerMonitor")});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.DIGITAL_CHEST), (Object[])new Object[]{"PPP", "PDP", "PCP", Character.valueOf('P'), "plateSteel", Character.valueOf('D'), ItemParts.getPartByName("dataOrb"), Character.valueOf('C'), ItemParts.getPartByName("computerMonitor")});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.ALLOY_SMELTER), (Object[])new Object[]{"XCX", "FMF", "XXX", Character.valueOf('C'), "circuitBasic", Character.valueOf('F'), IC2Duplicates.ELECTRICAL_FURNACE.getStackBasedOnConfig(), Character.valueOf('M'), BlockMachineFrame.getFrameByName("machine", 1)});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.LSU_STORAGE_BLOCK), (Object[])new Object[]{"LLL", "LCL", "LLL", Character.valueOf('L'), "blockLapis", Character.valueOf('C'), "circuitBasic"});
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemIngots.getIngotByName("hot_tungstensteel"), ItemIngots.getIngotByName("tungstensteel"), 440, 128));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemCells.getCellByName("heliumplasma"), ItemCells.getCellByName("helium"), 440, 128));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemCells.getCellByName("water"), ItemCells.getCellByName("cell"), 60, 128));
    }

    static void addVacuumFreezerRecipes() {
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(new ItemStack(Blocks.field_150432_aD, 2), new ItemStack(Blocks.field_150403_cj), 60, 100));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemIngots.getIngotByName("hot_tungstensteel"), ItemIngots.getIngotByName("tungstensteel"), 440, 120));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemCells.getCellByName("heliumplasma"), ItemCells.getCellByName("helium"), 440, 128));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemCells.getCellByName("water"), ItemCells.getCellByName("cell"), 60, 87));
    }

    static void addAlloySmelterRecipes() {
        RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 3), ItemIngots.getIngotByName("tin", 1), ItemIngots.getIngotByName("bronze", 4), 200, 16));
        RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 3), ItemDusts.getDustByName("tin", 1), ItemIngots.getIngotByName("bronze", 4), 200, 16));
        RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 3), ItemIngots.getIngotByName("tin", 1), ItemIngots.getIngotByName("bronze", 4), 200, 16));
        RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 3), ItemDusts.getDustByName("tin", 1), ItemIngots.getIngotByName("bronze", 4), 200, 16));
        RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(new ItemStack(Items.field_151043_k, 1), ItemIngots.getIngotByName("silver", 1), ItemIngots.getIngotByName("electrum", 2), 200, 16));
        RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(new ItemStack(Items.field_151043_k, 1), ItemDusts.getDustByName("silver", 1), ItemIngots.getIngotByName("electrum", 2), 200, 16));
        RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemDusts.getDustByName("gold", 1), ItemIngots.getIngotByName("silver", 1), ItemIngots.getIngotByName("electrum", 2), 200, 16));
        RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemDusts.getDustByName("gold", 1), ItemDusts.getDustByName("silver", 1), ItemIngots.getIngotByName("electrum", 2), 200, 16));
        RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(new ItemStack(Items.field_151042_j, 2), ItemIngots.getIngotByName("nickel", 1), ItemIngots.getIngotByName("invar", 3), 200, 16));
        RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(new ItemStack(Items.field_151042_j, 2), ItemDusts.getDustByName("nickel", 1), ItemIngots.getIngotByName("invar", 3), 200, 16));
        RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemDusts.getDustByName("iron", 2), ItemIngots.getIngotByName("nickel", 1), ItemIngots.getIngotByName("invar", 3), 200, 16));
        RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemDusts.getDustByName("iron", 2), ItemDusts.getDustByName("nickel", 1), ItemIngots.getIngotByName("invar", 3), 200, 16));
        if (OreUtil.doesOreExistAndValid((String)"ingotBrass")) {
            ItemStack brassStack = (ItemStack)OreDictionary.getOres((String)"ingotBrass").get(0);
            brassStack.field_77994_a = 4;
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 3), ItemIngots.getIngotByName("zinc", 1), brassStack, 200, 16));
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 3), ItemDusts.getDustByName("zinc", 1), brassStack, 200, 16));
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 3), ItemIngots.getIngotByName("zinc", 1), brassStack, 200, 16));
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 3), ItemDusts.getDustByName("zinc", 1), brassStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotRedAlloy")) {
            ItemStack redAlloyStack = (ItemStack)OreDictionary.getOres((String)"ingotRedAlloy").get(0);
            redAlloyStack.field_77994_a = 1;
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(new ItemStack(Items.field_151137_ax, 4), ItemIngots.getIngotByName("copper", 1), redAlloyStack, 200, 16));
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(new ItemStack(Items.field_151137_ax, 4), new ItemStack(Items.field_151042_j, 1), redAlloyStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotBlueAlloy")) {
            ItemStack blueAlloyStack = (ItemStack)OreDictionary.getOres((String)"ingotBlueAlloy").get(0);
            blueAlloyStack.field_77994_a = 1;
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemDusts.getDustByName("teslatite", 4), ItemIngots.getIngotByName("silver", 1), blueAlloyStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotPurpleAlloy") && OreUtil.doesOreExistAndValid((String)"dustInfusedTeslatite")) {
            ItemStack purpleAlloyStack = (ItemStack)OreDictionary.getOres((String)"ingotPurpleAlloy").get(0);
            purpleAlloyStack.field_77994_a = 1;
            ItemStack infusedTeslatiteStack = (ItemStack)OreDictionary.getOres((String)"ingotPurpleAlloy").get(0);
            infusedTeslatiteStack.field_77994_a = 8;
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemIngots.getIngotByName("redAlloy", 1), ItemIngots.getIngotByName("blueAlloy", 1), purpleAlloyStack, 200, 16));
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(new ItemStack(Items.field_151043_k, 1), infusedTeslatiteStack, purpleAlloyStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotAluminumBrass")) {
            ItemStack aluminumBrassStack = (ItemStack)OreDictionary.getOres((String)"ingotAluminumBrass").get(0);
            aluminumBrassStack.field_77994_a = 4;
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 3), ItemIngots.getIngotByName("aluminum", 1), aluminumBrassStack, 200, 16));
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemIngots.getIngotByName("copper", 3), ItemDusts.getDustByName("aluminum", 1), aluminumBrassStack, 200, 16));
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 3), ItemIngots.getIngotByName("aluminum", 1), aluminumBrassStack, 200, 16));
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(ItemDusts.getDustByName("copper", 3), ItemDusts.getDustByName("aluminum", 1), aluminumBrassStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotManyullyn") && OreUtil.doesOreExistAndValid((String)"ingotCobalt") && OreUtil.doesOreExistAndValid((String)"ingotArdite")) {
            ItemStack manyullynStack = (ItemStack)OreDictionary.getOres((String)"ingotManyullyn").get(0);
            manyullynStack.field_77994_a = 1;
            ItemStack cobaltStack = (ItemStack)OreDictionary.getOres((String)"ingotCobalt").get(0);
            cobaltStack.field_77994_a = 1;
            ItemStack arditeStack = (ItemStack)OreDictionary.getOres((String)"ingotArdite").get(0);
            arditeStack.field_77994_a = 1;
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(cobaltStack, arditeStack, manyullynStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotConductiveIron")) {
            ItemStack conductiveIronStack = (ItemStack)OreDictionary.getOres((String)"ingotConductiveIron").get(0);
            conductiveIronStack.field_77994_a = 1;
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(new ItemStack(Items.field_151137_ax, 1), new ItemStack(Items.field_151042_j, 1), conductiveIronStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotRedstoneAlloy") && OreUtil.doesOreExistAndValid((String)"itemSilicon")) {
            ItemStack redstoneAlloyStack = (ItemStack)OreDictionary.getOres((String)"ingotRedstoneAlloy").get(0);
            redstoneAlloyStack.field_77994_a = 1;
            ItemStack siliconStack = (ItemStack)OreDictionary.getOres((String)"itemSilicon").get(0);
            siliconStack.field_77994_a = 1;
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(new ItemStack(Items.field_151137_ax, 1), siliconStack, redstoneAlloyStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotPhasedIron")) {
            ItemStack pulsatingIronStack = (ItemStack)OreDictionary.getOres((String)"ingotPhasedIron").get(0);
            pulsatingIronStack.field_77994_a = 1;
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(new ItemStack(Items.field_151042_j, 1), new ItemStack(Items.field_151079_bi, 1), pulsatingIronStack, 200, 16));
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(new ItemStack(Items.field_151042_j, 1), ItemDusts.getDustByName("ender_pearl", 1), pulsatingIronStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotEnergeticAlloy") && OreUtil.doesOreExistAndValid((String)"ingotPhasedGold")) {
            ItemStack energeticAlloyStack = (ItemStack)OreDictionary.getOres((String)"ingotEnergeticAlloy").get(0);
            energeticAlloyStack.field_77994_a = 1;
            ItemStack vibrantAlloyStack = (ItemStack)OreDictionary.getOres((String)"ingotPhasedGold").get(0);
            vibrantAlloyStack.field_77994_a = 1;
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(energeticAlloyStack, new ItemStack(Items.field_151079_bi, 1), vibrantAlloyStack, 200, 16));
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(energeticAlloyStack, ItemDusts.getDustByName("ender_pearl", 1), vibrantAlloyStack, 200, 16));
        }
        if (OreUtil.doesOreExistAndValid((String)"ingotSoularium")) {
            ItemStack soulariumStack = (ItemStack)OreDictionary.getOres((String)"ingotSoularium").get(0);
            soulariumStack.field_77994_a = 1;
            RecipeHandler.addRecipe((IBaseRecipeType)new AlloySmelterRecipe(new ItemStack(Blocks.field_150425_aM, 1), new ItemStack(Items.field_151043_k, 1), soulariumStack, 200, 16));
        }
    }

    static void addBlastFurnaceRecipes() {
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDusts.getDustByName("titanium"), null, ItemIngots.getIngotByName("titanium"), null, 3600, 120, 1500));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("titanium", 4), null, ItemIngots.getIngotByName("titanium"), null, 3600, 120, 1500));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDusts.getDustByName("aluminum"), null, ItemIngots.getIngotByName("aluminum"), null, 2200, 120, 1700));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("aluminum", 4), null, ItemIngots.getIngotByName("aluminum"), null, 2200, 120, 1700));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDusts.getDustByName("tungsten"), null, ItemIngots.getIngotByName("tungsten"), null, 18000, 120, 2500));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("tungsten", 4), null, ItemIngots.getIngotByName("tungsten"), null, 18000, 120, 2500));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDusts.getDustByName("chrome"), null, ItemIngots.getIngotByName("chrome"), null, 4420, 120, 1700));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("chrome", 4), null, ItemIngots.getIngotByName("chrome"), null, 4420, 120, 1700));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDusts.getDustByName("steel"), null, ItemIngots.getIngotByName("steel"), null, 2800, 120, 1000));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("steel", 4), null, ItemIngots.getIngotByName("steel"), null, 2800, 120, 1000));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDusts.getDustByName("galena", 2), null, ItemIngots.getIngotByName("silver"), ItemIngots.getIngotByName("lead"), 80, 120, 1500));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(new ItemStack(Items.field_151042_j), ItemDusts.getDustByName("coal", 2), ItemIngots.getIngotByName("steel"), ItemDusts.getDustByName("dark_ashes", 2), 500, 120, 1000));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemIngots.getIngotByName("tungsten"), ItemIngots.getIngotByName("steel"), ItemIngots.getIngotByName("hot_tungstensteel"), ItemDusts.getDustByName("dark_ashes", 4), 500, 500, 3000));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(new ItemStack(Blocks.field_150366_p), ItemDusts.getDustByName("calcite"), new ItemStack(Items.field_151042_j, 3), ItemDusts.getDustByName("dark_ashes"), 140, 120, 1000));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(BlockOre.getOreByName("Pyrite"), ItemDusts.getDustByName("calcite"), new ItemStack(Items.field_151042_j, 2), ItemDusts.getDustByName("dark_ashes"), 140, 120, 1000));
    }

    static void addChemicalReactorRecipes() {
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(ItemCells.getCellByName("calcium", 1), ItemCells.getCellByName("carbon", 1), ItemCells.getCellByName("calciumCarbonate", 2), 240, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(new ItemStack(Items.field_151074_bl, 8), new ItemStack(Items.field_151127_ba, 1), new ItemStack(Items.field_151060_bw, 1), 40, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(ItemCells.getCellByName("nitrogen", 1), ItemCells.getCellByName("carbon", 1), ItemCells.getCellByName("nitrocarbon", 2), 1500, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(ItemCells.getCellByName("carbon", 1), ItemCells.getCellByName("hydrogen", 4), ItemCells.getCellByName("methane", 5), 3500, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(ItemCells.getCellByName("sulfur", 1), ItemCells.getCellByName("sodium", 1), ItemCells.getCellByName("sodiumSulfide", 2), 100, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(new ItemStack(Items.field_151065_br, 1), new ItemStack(Items.field_151079_bi, 1), new ItemStack(Items.field_151061_bv, 1), 40, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(new ItemStack(Items.field_151074_bl, 8), new ItemStack(Items.field_151172_bF, 1), new ItemStack(Items.field_151150_bK, 1), 40, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(ItemCells.getCellByName("glyceryl", 1), ItemCells.getCellByName("diesel", 4), ItemCells.getCellByName("nitroDiesel", 5), 1000, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(new ItemStack(Items.field_151043_k, 8), new ItemStack(Items.field_151034_e, 1), new ItemStack(Items.field_151153_ao, 1), 40, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(new ItemStack(Blocks.field_150340_R, 8), new ItemStack(Items.field_151034_e, 1), new ItemStack(Items.field_151153_ao, 1, 1), 40, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(new ItemStack(Items.field_151065_br, 1), new ItemStack(Items.field_151123_aH, 1), new ItemStack(Items.field_151064_bs, 1), 40, 30));
    }

    static void addIc2Recipes() {
        CraftingHelper.addShapelessOreRecipe((ItemStack)new ItemStack(ModItems.MANUAL), (Object[])new Object[]{IC2Duplicates.REFINED_IRON.getStackBasedOnConfig(), Items.field_151122_aG});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("machineParts", 16), (Object[])new Object[]{"CSC", "SCS", "CSC", Character.valueOf('S'), "ingotSteel", Character.valueOf('C'), "circuitBasic"});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("energyFlowCircuit", 4), (Object[])new Object[]{"ATA", "LIL", "ATA", Character.valueOf('T'), "ingotTungsten", Character.valueOf('I'), "plateIridium", Character.valueOf('A'), "circuitAdvanced", Character.valueOf('L'), "lapotronCrystal"});
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemParts.getPartByName("superconductor", 4), (Object[])new Object[]{"CCC", "TIT", "EEE", Character.valueOf('E'), "circuitMaster", Character.valueOf('C'), ItemParts.getPartByName("heliumCoolantSimple"), Character.valueOf('T'), "ingotTungsten", Character.valueOf('I'), "plateIridium"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.LAPOTRONIC_ORB), (Object[])new Object[]{"LLL", "LPL", "LLL", Character.valueOf('L'), "lapotronCrystal", Character.valueOf('P'), "plateIridium"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.INDUSTRIAL_SAWMILL), (Object[])new Object[]{"PAP", "SSS", "ACA", Character.valueOf('P'), IC2Duplicates.REFINED_IRON.getStackBasedOnConfig(), Character.valueOf('A'), "circuitAdvanced", Character.valueOf('S'), ItemParts.getPartByName("diamondSawBlade"), Character.valueOf('C'), "machineBlockAdvanced"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.CHARGE_O_MAT), (Object[])new Object[]{"ETE", "COC", "EAD", Character.valueOf('E'), "circuitMaster", Character.valueOf('T'), ModItems.ENERGY_CRYSTAL, Character.valueOf('C'), Blocks.field_150486_ae, Character.valueOf('O'), ModItems.LAPOTRONIC_ORB, Character.valueOf('A'), "machineBlockAdvanced"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.MATTER_FABRICATOR), (Object[])new Object[]{"ETE", "AOA", "ETE", Character.valueOf('E'), "circuitMaster", Character.valueOf('T'), IC2Duplicates.EXTRACTOR.getStackBasedOnConfig(), Character.valueOf('A'), BlockMachineFrame.getFrameByName("highlyAdvancedMachine", 1), Character.valueOf('O'), ModItems.LAPOTRONIC_ORB});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.HEAT_GENERATOR), (Object[])new Object[]{"III", "IHI", "CGC", Character.valueOf('I'), "plateIron", Character.valueOf('H'), new ItemStack(Blocks.field_150411_aY), Character.valueOf('C'), "circuitBasic", Character.valueOf('G'), IC2Duplicates.GENERATOR.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.GAS_TURBINE), (Object[])new Object[]{"IAI", "WGW", "IAI", Character.valueOf('I'), "ingotInvar", Character.valueOf('A'), "circuitAdvanced", Character.valueOf('W'), ModRecipes.getOre("ic2Windmill"), Character.valueOf('G'), ModRecipes.getOre("glassReinforced")});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.GAS_TURBINE), (Object[])new Object[]{"IAI", "WGW", "IAI", Character.valueOf('I'), "ingotAluminum", Character.valueOf('A'), "circuitAdvanced", Character.valueOf('W'), ModRecipes.getOre("ic2Windmill"), Character.valueOf('G'), ModRecipes.getOre("glassReinforced")});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.SEMIFLUID_GENERATOR), (Object[])new Object[]{"III", "IHI", "CGC", Character.valueOf('I'), "plateIron", Character.valueOf('H'), ModBlocks.REINFORCED_GLASS, Character.valueOf('C'), "circuitBasic", Character.valueOf('G'), IC2Duplicates.GENERATOR.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.SEMIFLUID_GENERATOR), (Object[])new Object[]{"AAA", "AHA", "CGC", Character.valueOf('A'), "plateAluminum", Character.valueOf('H'), ModBlocks.REINFORCED_GLASS, Character.valueOf('C'), "circuitBasic", Character.valueOf('G'), IC2Duplicates.GENERATOR.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.DIESEL_GENERATOR), (Object[])new Object[]{"III", "I I", "CGC", Character.valueOf('I'), IC2Duplicates.REFINED_IRON.getStackBasedOnConfig(), Character.valueOf('C'), "circuitBasic", Character.valueOf('G'), IC2Duplicates.GENERATOR.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.DIESEL_GENERATOR), (Object[])new Object[]{"AAA", "A A", "CGC", Character.valueOf('A'), "ingotAluminum", Character.valueOf('C'), "circuitBasic", Character.valueOf('G'), IC2Duplicates.GENERATOR.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.INDUSTRIAL_BLAST_FURNACE), (Object[])new Object[]{"CHC", "HBH", "FHF", Character.valueOf('H'), ItemParts.getPartByName("cupronickelHeatingCoil"), Character.valueOf('C'), "circuitAdvanced", Character.valueOf('B'), BlockMachineFrame.getFrameByName("advancedMachine", 1), Character.valueOf('F'), IC2Duplicates.ELECTRICAL_FURNACE.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.INDUSTRIAL_GRINDER), (Object[])new Object[]{"ECG", "HHH", "CBC", Character.valueOf('E'), ModBlocks.INDUSTRIAL_ELECTROLYZER, Character.valueOf('H'), "craftingGrinder", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('B'), "machineBlockAdvanced", Character.valueOf('G'), IC2Duplicates.GRINDER.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.IMPLOSION_COMPRESSOR), (Object[])new Object[]{"ABA", "CPC", "ABA", Character.valueOf('A'), ItemIngots.getIngotByName("advancedAlloy"), Character.valueOf('C'), "circuitAdvanced", Character.valueOf('B'), BlockMachineFrame.getFrameByName("advancedMachine", 1), Character.valueOf('P'), IC2Duplicates.COMPRESSOR.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.VACUUM_FREEZER), (Object[])new Object[]{"SPS", "CGC", "SPS", Character.valueOf('S'), "plateSteel", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('G'), ModBlocks.REINFORCED_GLASS, Character.valueOf('P'), IC2Duplicates.EXTRACTOR.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.DISTILLATION_TOWER), (Object[])new Object[]{"CMC", "PBP", "EME", Character.valueOf('E'), ModBlocks.INDUSTRIAL_ELECTROLYZER, Character.valueOf('M'), "circuitMaster", Character.valueOf('B'), "machineBlockAdvanced", Character.valueOf('C'), ModBlocks.INDUSTRIAL_CENTRIFUGE, Character.valueOf('P'), IC2Duplicates.EXTRACTOR.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.IRON_ALLOY_FURNACE), (Object[])new Object[]{"III", "F F", "III", Character.valueOf('I'), ItemIngots.getIngotByName("refined_iron"), Character.valueOf('F'), new ItemStack(ModBlocks.IRON_FURNACE)});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.IRON_ALLOY_FURNACE), (Object[])new Object[]{"III", "F F", "III", Character.valueOf('I'), IC2Duplicates.REFINED_IRON.getStackBasedOnConfig(), Character.valueOf('F'), IC2Duplicates.IRON_FURNACE.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.CHEMICAL_REACTOR), (Object[])new Object[]{"IMI", "CPC", "IEI", Character.valueOf('I'), "ingotInvar", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('M'), IC2Duplicates.EXTRACTOR.getStackBasedOnConfig(), Character.valueOf('P'), IC2Duplicates.COMPRESSOR.getStackBasedOnConfig(), Character.valueOf('E'), IC2Duplicates.EXTRACTOR.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.ROLLING_MACHINE), (Object[])new Object[]{"PCP", "MBM", "PCP", Character.valueOf('P'), Blocks.field_150331_J, Character.valueOf('C'), "circuitAdvanced", Character.valueOf('M'), IC2Duplicates.COMPRESSOR.getStackBasedOnConfig(), Character.valueOf('B'), BlockMachineFrame.getFrameByName("machine", 1)});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.LAPOTRONIC_SU), (Object[])new Object[]{" L ", "CBC", " M ", Character.valueOf('L'), IC2Duplicates.LVT.getStackBasedOnConfig(), Character.valueOf('C'), "circuitAdvanced", Character.valueOf('M'), IC2Duplicates.MVT.getStackBasedOnConfig(), Character.valueOf('B'), ModBlocks.LSU_STORAGE_BLOCK});
        CraftingHelper.addShapedOreRecipe((ItemStack)BlockMachineFrame.getFrameByName("highlyAdvancedMachine", 1), (Object[])new Object[]{"CTC", "TBT", "CTC", Character.valueOf('C'), "ingotChrome", Character.valueOf('T'), "ingotTitanium", Character.valueOf('B'), "machineBlockAdvanced"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.MACHINE_CASINGS, 4, 0), (Object[])new Object[]{"III", "CBC", "III", Character.valueOf('I'), "plateIron", Character.valueOf('C'), "circuitBasic", Character.valueOf('B'), "machineBlockBasic"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.MACHINE_CASINGS, 4, 1), (Object[])new Object[]{"SSS", "CBC", "SSS", Character.valueOf('S'), "plateSteel", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('B'), "machineBlockAdvanced"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.MACHINE_CASINGS, 4, 2), (Object[])new Object[]{"HHH", "CBC", "HHH", Character.valueOf('H'), "ingotChrome", Character.valueOf('C'), "circuitElite", Character.valueOf('B'), BlockMachineFrame.getFrameByName("highlyAdvancedMachine", 1)});
        if (!CompatManager.isQuantumStorageLoaded) {
            CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModBlocks.QUANTUM_CHEST), (Object[])new Object[]{"DCD", "ATA", "DQD", Character.valueOf('D'), ItemParts.getPartByName("dataOrb"), Character.valueOf('C'), ItemParts.getPartByName("computerMonitor"), Character.valueOf('A'), BlockMachineFrame.getFrameByName("highlyAdvancedMachine", 1), Character.valueOf('Q'), ModBlocks.DIGITAL_CHEST, Character.valueOf('T'), IC2Duplicates.COMPRESSOR.getStackBasedOnConfig()});
        }
        CraftingHelper.addSmelting((ItemStack)ItemDusts.getDustByName("copper", 1), (ItemStack)ModRecipes.getOre("ingotCopper"), (float)1.0f);
        CraftingHelper.addSmelting((ItemStack)ItemDusts.getDustByName("tin", 1), (ItemStack)ItemIngots.getIngotByName("tin"), (float)1.0f);
        CraftingHelper.addSmelting((ItemStack)ItemDusts.getDustByName("bronze", 1), (ItemStack)ItemIngots.getIngotByName("bronze"), (float)1.0f);
        CraftingHelper.addSmelting((ItemStack)ItemDusts.getDustByName("lead", 1), (ItemStack)ItemIngots.getIngotByName("lead"), (float)1.0f);
        CraftingHelper.addSmelting((ItemStack)ItemDusts.getDustByName("silver", 1), (ItemStack)ItemIngots.getIngotByName("silver"), (float)1.0f);
        if (ConfigTechReborn.UUrecipesIridiamOre) {
            CraftingHelper.addShapedOreRecipe((ItemStack)((ItemStack)OreDictionary.getOres((String)"oreIridium").get(0)), (Object[])new Object[]{"UUU", " U ", "UUU", Character.valueOf('U'), ModItems.UU_MATTER});
        }
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(ItemDusts.getDustByName("calcite", 1), null, new ItemStack(((ItemStack)OreDictionary.getOres((String)"fertilizer").get(0)).func_77973_b(), 1), 100, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(ItemDusts.getDustByName("calcite", 1), ItemDusts.getDustByName("phosphorous", 1), new ItemStack(((ItemStack)OreDictionary.getOres((String)"fertilizer").get(0)).func_77973_b(), 3), 100, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(ItemCells.getCellByName("sodiumSulfide", 1), ItemCells.getCellByName("empty"), ItemCells.getCellByName("sodiumPersulfate", 2), 2000, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(ItemCells.getCellByName("nitrocarbon", 1), ItemCells.getCellByName("water"), ItemCells.getCellByName("glyceryl", 2), 580, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(ItemDusts.getDustByName("calcite", 1), ItemDusts.getDustByName("sulfur", 1), new ItemStack(((ItemStack)OreDictionary.getOres((String)"fertilizer").get(0)).func_77973_b(), 2), 100, 30));
        ItemStack waterCells = ItemCells.getCellByName("water").func_77946_l();
        waterCells.field_77994_a = 2;
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(ItemCells.getCellByName("sulfur", 1), waterCells, ItemCells.getCellByName("sulfuricAcid", 3), 1140, 30));
        ItemStack waterCells2 = ItemCells.getCellByName("water").func_77946_l();
        waterCells2.field_77994_a = 5;
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(ItemCells.getCellByName("hydrogen", 4), ItemCells.getCellByName("empty"), waterCells2, 10, 30));
        RecipeHandler.addRecipe((IBaseRecipeType)new ChemicalReactorRecipe(ItemCells.getCellByName("nitrogen", 1), ItemCells.getCellByName("empty"), ItemCells.getCellByName("nitrogenDioxide", 2), 1240, 30));
        if (ConfigTechReborn.ExpensiveMacerator && !IC2Duplicates.deduplicate()) {
            CraftingHelper.addShapedOreRecipe((ItemStack)ModRecipes.getOre("ic2Macerator"), (Object[])new Object[]{"FDF", "DMD", "FCF", Character.valueOf('F'), Items.field_151145_ak, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('M'), "machineBlockBasic", Character.valueOf('C'), "circuitBasic"});
        }
        if (ConfigTechReborn.ExpensiveSolar && !IC2Duplicates.deduplicate()) {
            CraftingHelper.addShapedOreRecipe((ItemStack)IC2Duplicates.SOLAR_PANEL.getStackBasedOnConfig(), (Object[])new Object[]{"PPP", "SZS", "CGC", Character.valueOf('P'), "paneGlass", Character.valueOf('S'), ItemPlates.getPlateByName("lazurite"), Character.valueOf('Z'), "plateCarbon", Character.valueOf('G'), IC2Duplicates.GENERATOR.getStackBasedOnConfig(), Character.valueOf('C'), "circuitBasic"});
        }
        CraftingHelper.addShapedOreRecipe((ItemStack)ItemIngots.getIngotByName("iridium_alloy"), (Object[])new Object[]{"IAI", "ADA", "IAI", Character.valueOf('I'), "ingotIridium", Character.valueOf('D'), ItemDusts.getDustByName("diamond"), Character.valueOf('A'), "plateAdvancedAlloy"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.LITHIUM_BATTERY_PACK, 1, Short.MAX_VALUE), (Object[])new Object[]{"BCB", "BPB", "B B", Character.valueOf('B'), new ItemStack(ModItems.LITHIUM_BATTERY), Character.valueOf('P'), "plateAluminum", Character.valueOf('C'), "circuitAdvanced"});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.LITHIUM_BATTERY, 1, Short.MAX_VALUE), (Object[])new Object[]{" C ", "PFP", "PFP", Character.valueOf('F'), ItemCells.getCellByName("lithium"), Character.valueOf('P'), "plateAluminum", Character.valueOf('C'), IC2Duplicates.CABLE_IGOLD.getStackBasedOnConfig()});
        CraftingHelper.addShapedOreRecipe((ItemStack)new ItemStack(ModItems.LAPOTRONIC_ORB_PACK, 1, Short.MAX_VALUE), (Object[])new Object[]{"FOF", "SPS", "FIF", Character.valueOf('F'), "circuitMaster", Character.valueOf('O'), new ItemStack(ModItems.LAPOTRONIC_ORB), Character.valueOf('S'), ItemParts.getPartByName("superConductor"), Character.valueOf('I'), "ingotIridium", Character.valueOf('P'), new ItemStack(ModItems.LITHIUM_BATTERY_PACK)});
    }

    public static ItemStack getBucketWithFluid(Fluid fluid) {
        return UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)fluid);
    }

    public static ItemStack getOre(String name) {
        if (OreDictionary.getOres((String)name).isEmpty()) {
            return new ItemStack(ModItems.MISSING_RECIPE_PLACEHOLDER);
        }
        return ((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77946_l();
    }
}

