/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import techreborn.Core;
import techreborn.blocks.BlockMachineFrame;
import techreborn.init.IC2Dict;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ItemDusts;
import techreborn.items.ItemDustsSmall;
import techreborn.items.ItemGems;
import techreborn.items.ItemIngots;
import techreborn.items.ItemNuggets;
import techreborn.items.ItemParts;
import techreborn.items.ItemPlates;
import techreborn.parts.powerCables.ItemStandaloneCables;

public class OreDict {
    private static final ImmutableList<String> plateGenIgnores = ImmutableList.of((Object)"hot", (Object)"mixed_metal", (Object)"iridium_alloy", (Object)"PLACEHOLDER_ITEM");

    public static void init() {
        boolean ignoreIt;
        if (Loader.isModLoaded((String)"IC2")) {
            Core.logHelper.info((Object)"IC2 installed, enabling integration");
            IC2Dict.init();
        }
        OreDictionary.registerOre((String)"reBattery", (Item)ModItems.RE_BATTERY);
        OreDictionary.registerOre((String)"circuitBasic", (ItemStack)ItemParts.getPartByName("electronicCircuit"));
        OreDictionary.registerOre((String)"circuitAdvanced", (ItemStack)ItemParts.getPartByName("advancedCircuit"));
        OreDictionary.registerOre((String)"circuitStorage", (ItemStack)ItemParts.getPartByName("dataStorageCircuit"));
        OreDictionary.registerOre((String)"circuitElite", (ItemStack)ItemParts.getPartByName("dataControlCircuit"));
        OreDictionary.registerOre((String)"circuitMaster", (ItemStack)ItemParts.getPartByName("energyFlowCircuit"));
        OreDictionary.registerOre((String)"machineBlockBasic", (ItemStack)BlockMachineFrame.getFrameByName("machine", 1));
        OreDictionary.registerOre((String)"machineBlockAdvanced", (ItemStack)BlockMachineFrame.getFrameByName("advancedMachine", 1));
        OreDictionary.registerOre((String)"machineBlockElite", (ItemStack)BlockMachineFrame.getFrameByName("highlyAdvancedMachine", 1));
        OreDictionary.registerOre((String)"lapotronCrystal", (Item)ModItems.LAPOTRONIC_CRYSTAL);
        OreDictionary.registerOre((String)"energyCrystal", (Item)ModItems.ENERGY_CRYSTAL);
        OreDictionary.registerOre((String)"drillBasic", (Item)ModItems.DIAMOND_DRILL);
        OreDictionary.registerOre((String)"drillDiamond", (Item)ModItems.DIAMOND_DRILL);
        OreDictionary.registerOre((String)"industrialTnt", (Block)Blocks.field_150335_W);
        OreDictionary.registerOre((String)"craftingIndustrialDiamond", (Item)Items.field_151045_i);
        OreDictionary.registerOre((String)"insulatedGoldCableItem", (ItemStack)ItemStandaloneCables.getCableByName("insulatedgold"));
        OreDictionary.registerOre((String)"fertilizer", (ItemStack)new ItemStack(Items.field_151100_aR, 1, 15));
        OreDictionary.registerOre((String)"ic2Generator", (Block)ModBlocks.SOLID_FUEL_GENEREATOR);
        OreDictionary.registerOre((String)"ic2SolarPanel", (Block)ModBlocks.SOLAR_PANEL);
        OreDictionary.registerOre((String)"ic2Macerator", (Block)ModBlocks.GRINDER);
        OreDictionary.registerOre((String)"ic2Extractor", (Block)ModBlocks.EXTRACTOR);
        OreDictionary.registerOre((String)"ic2Windmill", (Block)ModBlocks.WIND_MILL);
        OreDictionary.registerOre((String)"ic2Watermill", (Block)ModBlocks.WATER_MILL);
        OreDictionary.registerOre((String)"fenceIron", (Block)ModBlocks.REFINED_IRON_FENCE);
        OreDictionary.registerOre((String)"glassReinforced", (Block)ModBlocks.REINFORCED_GLASS);
        OreDictionary.registerOre((String)"craftingGrinder", (ItemStack)ItemParts.getPartByName("diamondGrindingHead"));
        OreDictionary.registerOre((String)"craftingGrinder", (ItemStack)ItemParts.getPartByName("tungstenGrindingHead"));
        OreDictionary.registerOre((String)"craftingSuperconductor", (ItemStack)ItemParts.getPartByName("superconductor"));
        OreDictionary.registerOre((String)"batteryUltimate", (ItemStack)ItemParts.getPartByName("diamondGrindingHead"));
        OreDictionary.registerOre((String)"materialResin", (ItemStack)ItemParts.getPartByName("rubberSap"));
        OreDictionary.registerOre((String)"materialRubber", (ItemStack)ItemParts.getPartByName("rubber"));
        OreDictionary.registerOre((String)"itemRubber", (ItemStack)ItemParts.getPartByName("rubber"));
        OreDictionary.registerOre((String)"pulpWood", (ItemStack)ItemDusts.getDustByName("saw_dust"));
        for (String type : ItemGems.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            OreDictionary.registerOre((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "gem_" + type), (ItemStack)ItemGems.getGemByName(type));
            ignoreIt = false;
            for (String ignore : plateGenIgnores) {
                if (!type.startsWith(ignore)) continue;
                ignoreIt = true;
            }
            if (ignoreIt) continue;
            ItemPlates.registerType(type);
        }
        for (String type : ItemIngots.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            OreDictionary.registerOre((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "ingot_" + type), (ItemStack)ItemIngots.getIngotByName(type));
            ignoreIt = false;
            for (String ignore : plateGenIgnores) {
                if (!type.startsWith(ignore)) continue;
                ignoreIt = true;
            }
            if (ignoreIt) continue;
            ItemPlates.registerType(type);
        }
        for (String type : ItemPlates.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            OreDictionary.registerOre((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "plate_" + type), (ItemStack)ItemPlates.getPlateByName(type));
        }
        for (String type : ItemDusts.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            OreDictionary.registerOre((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "dust_" + type), (ItemStack)ItemDusts.getDustByName(type));
        }
        for (String type : ItemDustsSmall.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            OreDictionary.registerOre((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "dust_tiny_" + type), (ItemStack)ItemDustsSmall.getSmallDustByName(type));
            OreDictionary.registerOre((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "dust_small_" + type), (ItemStack)ItemDustsSmall.getSmallDustByName(type));
        }
        for (String type : ItemNuggets.types) {
            if (type.equals("PLACEHOLDER_ITEM")) continue;
            OreDictionary.registerOre((String)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, "nugget_" + type), (ItemStack)ItemNuggets.getNuggetByName(type));
        }
    }
}

