/*
 * Decompiled with CFR 0.152.
 */
package techreborn.api.fluidreplicator;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import reborncore.common.util.FluidUtils;
import techreborn.init.ModItems;
import techreborn.tiles.multiblock.TileFluidReplicator;

public class FluidReplicatorRecipe
implements Cloneable {
    @Nonnull
    private final int input;
    @Nonnull
    private final Fluid output;
    private final int tickTime;
    private final int euPerTick;

    public FluidReplicatorRecipe(int input, Fluid output, int tickTime, int euPerTick) {
        this.input = input;
        this.output = output;
        this.tickTime = tickTime;
        this.euPerTick = euPerTick;
    }

    public int getInput() {
        return this.input;
    }

    public Fluid getFluid() {
        return this.output;
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public int getEuTick() {
        return this.euPerTick;
    }

    public List<Object> getInputs() {
        ArrayList<Object> inputs = new ArrayList<Object>();
        inputs.add(new ItemStack(ModItems.UU_MATTER, this.input));
        return inputs;
    }

    public boolean useOreDic() {
        return false;
    }

    public boolean canCraft(TileFluidReplicator tile) {
        if (!tile.getMultiBlock()) {
            return false;
        }
        BlockPos hole = tile.getPos().offset(tile.getFacing().getOpposite(), 2);
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)tile.getWorld().getBlockState(hole).getBlock());
        if (fluid == null) {
            return false;
        }
        if (!FluidUtils.fluidEquals((Fluid)fluid, (Fluid)this.output)) {
            return false;
        }
        Fluid tankFluid = tile.tank.getFluidType();
        return tankFluid == null || FluidUtils.fluidEquals((Fluid)tankFluid, (Fluid)fluid);
    }

    public boolean onCraft(TileFluidReplicator tile) {
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

