/*
 * Decompiled with CFR 0.152.
 */
package techreborn.api.fluidreplicator;

import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.api.Reference;
import techreborn.api.fluidreplicator.FluidReplicatorRecipe;
import techreborn.api.fluidreplicator.FluidReplicatorRecipeList;
import techreborn.init.ModItems;
import techreborn.tiles.multiblock.TileFluidReplicator;

public class FluidReplicatorRecipeCrafter
extends RecipeCrafter {
    public FluidReplicatorRecipe currentRecipe;
    int ticksSinceLastChange;

    public FluidReplicatorRecipeCrafter(TileEntity parentTile, Inventory inventory, int[] inputSlots, int[] outputSlots) {
        super(Reference.FLUID_REPLICATOR_RECIPE, parentTile, 1, 1, inventory, inputSlots, outputSlots);
    }

    private boolean hasAllInputs(FluidReplicatorRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack inputStack = this.inventory.getStackInSlot(this.inputSlots[0]);
        if (!inputStack.isItemEqual(new ItemStack(ModItems.UU_MATTER))) {
            return false;
        }
        return inputStack.getCount() >= recipe.getInput();
    }

    private boolean canFit(Fluid fluid, Tank tank) {
        return tank.fill(new FluidStack(fluid, 1000), false) == 1000;
    }

    public void setCurrentRecipe(FluidReplicatorRecipe recipe) {
        try {
            this.currentRecipe = (FluidReplicatorRecipe)recipe.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public void updateEntity() {
        if (this.parentTile.getWorld().isRemote) {
            return;
        }
        ++this.ticksSinceLastChange;
        if (this.ticksSinceLastChange >= 20) {
            this.setInvDirty(true);
            this.ticksSinceLastChange = 0;
        }
        if (this.currentRecipe == null && this.isInvDirty()) {
            this.updateCurrentRecipe();
        }
        if (this.currentRecipe != null) {
            if (this.isInvDirty() && !this.hasAllInputs()) {
                this.currentRecipe = null;
                this.currentTickTime = 0;
                this.setIsActive();
            }
            if (this.currentRecipe != null && this.currentTickTime >= this.currentNeededTicks && this.hasAllInputs()) {
                TileFluidReplicator tileFluidReplicator = (TileFluidReplicator)this.parentTile;
                if (this.canFit(this.currentRecipe.getFluid(), tileFluidReplicator.tank) && this.currentRecipe.onCraft(tileFluidReplicator)) {
                    tileFluidReplicator.tank.fill(new FluidStack(this.currentRecipe.getFluid(), 1000), true);
                    this.useAllInputs();
                    this.currentRecipe = null;
                    this.currentTickTime = 0;
                    this.updateCurrentRecipe();
                    if (this.currentRecipe == null) {
                        this.setIsActive();
                    }
                }
            } else if (this.currentRecipe != null && this.currentTickTime < this.currentNeededTicks && this.energy.canUseEnergy(this.getEuPerTick(this.currentRecipe.getEuTick()))) {
                this.energy.useEnergy(this.getEuPerTick(this.currentRecipe.getEuTick()));
                ++this.currentTickTime;
                if (this.currentTickTime == 1 || this.currentTickTime % 20 == 0 && soundHanlder != null) {
                    soundHanlder.playSound(false, this.parentTile);
                }
            }
        }
        this.setInvDirty(false);
    }

    public void updateCurrentRecipe() {
        TileFluidReplicator tileFluidReplicator = (TileFluidReplicator)this.parentTile;
        for (FluidReplicatorRecipe recipe : FluidReplicatorRecipeList.recipes) {
            if (!recipe.canCraft(tileFluidReplicator) || !this.hasAllInputs(recipe)) continue;
            if (!this.canFit(recipe.getFluid(), tileFluidReplicator.tank)) {
                this.currentRecipe = null;
                this.currentTickTime = 0;
                this.setIsActive();
                return;
            }
            this.setCurrentRecipe(recipe);
            this.currentNeededTicks = Math.max((int)((double)this.currentRecipe.getTickTime() * (1.0 - this.getSpeedMultiplier())), 1);
            this.currentTickTime = 0;
            this.setIsActive();
            return;
        }
    }

    public boolean hasAllInputs() {
        if (this.currentRecipe == null) {
            return false;
        }
        return this.hasAllInputs(this.currentRecipe);
    }

    public void useAllInputs() {
        if (this.currentRecipe == null) {
            return;
        }
        if (this.hasAllInputs(this.currentRecipe)) {
            this.inventory.decrStackSize(this.inputSlots[0], this.currentRecipe.getInput());
        }
    }

    public boolean canCraftAgain() {
        TileFluidReplicator tileFluidReplicator = (TileFluidReplicator)this.parentTile;
        for (FluidReplicatorRecipe recipe : FluidReplicatorRecipeList.recipes) {
            if (!recipe.canCraft(tileFluidReplicator) || !this.hasAllInputs(recipe)) continue;
            if (!this.canFit(recipe.getFluid(), tileFluidReplicator.tank)) {
                return false;
            }
            return !(this.energy.getEnergy() < (double)recipe.getEuTick());
        }
        return false;
    }
}

