/*
 * Decompiled with CFR 0.152.
 */
package techreborn.api.fluidreplicator;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraftforge.fluids.Fluid;
import org.apache.commons.lang3.Validate;
import reborncore.common.util.FluidUtils;
import techreborn.api.fluidreplicator.FluidReplicatorRecipe;

public class FluidReplicatorRecipeList {
    public static ArrayList<FluidReplicatorRecipe> recipes = new ArrayList();

    public static void addRecipe(FluidReplicatorRecipe recipe) {
        Validate.notNull((Object)recipe);
        Validate.isTrue((!recipes.contains(recipe) ? 1 : 0) != 0);
        Validate.validState((recipe.getInput() >= 1 ? 1 : 0) != 0);
        Validate.validState((!FluidReplicatorRecipeList.getRecipeForFluid(recipe.getFluid()).isPresent() ? 1 : 0) != 0);
        recipes.add(recipe);
    }

    public static boolean removeRecipe(FluidReplicatorRecipe recipe) {
        return recipes.remove(recipe);
    }

    public static Optional<FluidReplicatorRecipe> getRecipeForFluid(Fluid fluid) {
        return recipes.stream().filter(recipe -> FluidUtils.fluidEquals((Fluid)recipe.getFluid(), (Fluid)fluid)).findAny();
    }
}

