/*
 * Decompiled with CFR 0.152.
 */
package techreborn.api.recipe;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.common.recipes.RecipeTranslator;
import techreborn.api.recipe.ITileRecipeHandler;

public abstract class BaseRecipe
implements IBaseRecipeType,
Cloneable {
    public String name;
    public int tickTime;
    public int euPerTick;
    private ArrayList<Object> inputs = new ArrayList();
    private ArrayList<ItemStack> outputs = new ArrayList();
    private boolean oreDict = true;

    public BaseRecipe(String name, int tickTime, int euPerTick) {
        this.name = name;
        this.tickTime = tickTime;
        this.euPerTick = euPerTick;
    }

    public ItemStack getOutput(int i) {
        return this.outputs.get(i).copy();
    }

    public int getOutputsSize() {
        return this.outputs.size();
    }

    public void addOutput(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            throw new InvalidParameterException("Output stack is null or empty");
        }
        this.outputs.add(stack);
    }

    public List<Object> getInputs() {
        return this.inputs;
    }

    public String getRecipeName() {
        return this.name;
    }

    public int tickTime() {
        return this.tickTime;
    }

    public int euPerTick() {
        return this.euPerTick;
    }

    public boolean canCraft(TileEntity tile) {
        if (tile instanceof ITileRecipeHandler) {
            return ((ITileRecipeHandler)tile).canCraft(tile, this);
        }
        return true;
    }

    public boolean onCraft(TileEntity tile) {
        if (tile instanceof ITileRecipeHandler) {
            return ((ITileRecipeHandler)tile).onCraft(tile, this);
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setOreDict(boolean oreDict) {
        this.oreDict = oreDict;
    }

    public boolean useOreDic() {
        return this.oreDict;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public void addInput(Object inuput) {
        if (inuput == null) {
            throw new InvalidParameterException("input is invalid!");
        }
        if (inuput instanceof ItemStack && ((ItemStack)inuput).isEmpty()) {
            throw new InvalidParameterException("input is invalid!");
        }
        if (RecipeTranslator.getStackFromObject((Object)inuput) == null || RecipeTranslator.getStackFromObject((Object)inuput).isEmpty()) {
            throw new InvalidParameterException("Could not determin recipe input for " + inuput);
        }
        this.inputs.add(inuput);
    }
}

