/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.ToolManager;
import reborncore.api.tile.IMachineGuiHandler;
import reborncore.common.blocks.BlockMachineBase;
import techreborn.init.ModBlocks;
import techreborn.init.ModSounds;
import techreborn.utils.TechRebornCreativeTab;

public class BlockComputerCube
extends BlockMachineBase {
    public BlockComputerCube() {
        this.setUnlocalizedName("techreborn.computercube");
        this.setCreativeTab(TechRebornCreativeTab.instance);
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, "machines/tier2_machines", new IProperty[0]));
    }

    public IMachineGuiHandler getGui() {
        return null;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack tool = playerIn.getHeldItem(EnumHand.MAIN_HAND);
        if (!tool.isEmpty() && ToolManager.INSTANCE.canHandleTool(tool) && ToolManager.INSTANCE.handleTool(tool, pos, worldIn, playerIn, side, false)) {
            if (playerIn.isSneaking()) {
                ItemStack drop = new ItemStack(ModBlocks.COMPUTER_CUBE, 1);
                BlockComputerCube.spawnAsEntity((World)worldIn, (BlockPos)pos, (ItemStack)drop);
                worldIn.playSound(null, playerIn.posX, playerIn.posY, playerIn.posZ, ModSounds.BLOCK_DISMANTLE, SoundCategory.BLOCKS, 0.6f, 1.0f);
                if (!worldIn.isRemote) {
                    worldIn.setBlockState(pos, Blocks.AIR.getDefaultState(), 2);
                }
                return true;
            }
            this.rotateBlock(worldIn, pos, side);
            return true;
        }
        return false;
    }
}

