/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techreborn.tiles.TileEntityFlare;
import techreborn.utils.TechRebornCreativeTab;

public class BlockFlare
extends BlockContainer {
    public static final AxisAlignedBB FLARE_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1, 1.0);
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.create((String)"color", EnumDyeColor.class);

    public BlockFlare() {
        super(Material.REDSTONE_LIGHT);
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setUnlocalizedName("techreborn.flare");
        this.setDefaultState(this.blockState.getBaseState().withProperty(COLOR, (Comparable)EnumDyeColor.WHITE));
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        if (worldIn.isRemote) {
            return new TileEntityFlare();
        }
        return null;
    }

    public int damageDropped(IBlockState state) {
        return ((EnumDyeColor)state.getValue(COLOR)).getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (EnumDyeColor enumdyecolor : EnumDyeColor.values()) {
            list.add(new ItemStack(itemIn, 1, enumdyecolor.getMetadata()));
        }
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(COLOR, (Comparable)EnumDyeColor.byMetadata((int)meta));
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumDyeColor)state.getValue(COLOR)).getMetadata();
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR});
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isFullCube() {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return FLARE_BB;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLARE_BB;
    }
}

