/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.ToolManager;
import techreborn.init.ModBlocks;
import techreborn.init.ModSounds;
import techreborn.utils.TechRebornCreativeTab;

public class BlockFusionCoil
extends Block {
    public BlockFusionCoil() {
        super(Material.IRON);
        this.setHardness(2.0f);
        this.setSoundType(SoundType.METAL);
        this.setCreativeTab(TechRebornCreativeTab.instance);
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, "machines/generators", new IProperty[0]));
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack tool = playerIn.getHeldItem(EnumHand.MAIN_HAND);
        if (!tool.isEmpty() && ToolManager.INSTANCE.canHandleTool(tool) && ToolManager.INSTANCE.handleTool(tool, pos, worldIn, playerIn, side, false) && playerIn.isSneaking()) {
            ItemStack drop = new ItemStack(ModBlocks.FUSION_COIL, 1);
            BlockFusionCoil.spawnAsEntity((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            worldIn.playSound(null, playerIn.posX, playerIn.posY, playerIn.posZ, ModSounds.BLOCK_DISMANTLE, SoundCategory.BLOCKS, 0.6f, 1.0f);
            if (!worldIn.isRemote) {
                worldIn.setBlockState(pos, Blocks.AIR.getDefaultState(), 2);
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add("Right click Fusion Control computer to auto place");
    }
}

