/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.tile.IMachineGuiHandler;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.util.Torus;
import techreborn.client.EGui;
import techreborn.init.ModBlocks;
import techreborn.tiles.fusionReactor.TileFusionControlComputer;
import techreborn.utils.TechRebornCreativeTab;
import techreborn.utils.damageSources.FusionDamageSource;

public class BlockFusionControlComputer
extends BlockMachineBase {
    public BlockFusionControlComputer() {
        this.setCreativeTab(TechRebornCreativeTab.instance);
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, "machines/generators", new IProperty[0]));
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileFusionControlComputer tileFusionControlComputer = (TileFusionControlComputer)world.getTileEntity(pos);
        if (!player.getHeldItem(hand).isEmpty() && player.getHeldItem(hand).getItem() == Item.getItemFromBlock((Block)ModBlocks.FUSION_COIL)) {
            List coils = Torus.generate((BlockPos)tileFusionControlComputer.getPos(), (int)tileFusionControlComputer.size);
            boolean placed = false;
            for (BlockPos coil : coils) {
                if (player.getHeldItem(hand).isEmpty()) {
                    return true;
                }
                if (!world.isAirBlock(coil) || tileFusionControlComputer.isCoil(coil)) continue;
                world.setBlockState(coil, ModBlocks.FUSION_COIL.getDefaultState());
                if (!player.isCreative()) {
                    player.getHeldItem(hand).shrink(1);
                }
                placed = true;
            }
            if (placed) {
                return true;
            }
        }
        tileFusionControlComputer.checkCoils();
        return super.onBlockActivated(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    public IMachineGuiHandler getGui() {
        return EGui.FUSION_CONTROLLER;
    }

    public void onEntityWalk(World worldIn, BlockPos pos, Entity entityIn) {
        super.onEntityWalk(worldIn, pos, entityIn);
        if (worldIn.getTileEntity(pos) instanceof TileFusionControlComputer && ((TileFusionControlComputer)worldIn.getTileEntity((BlockPos)pos)).crafingTickTime != 0 && ((TileFusionControlComputer)worldIn.getTileEntity(pos)).checkCoils()) {
            entityIn.attackEntityFrom((DamageSource)new FusionDamageSource(), 200.0f);
        }
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileFusionControlComputer();
    }

    public boolean isAdvanced() {
        return true;
    }
}

