/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.ToolManager;
import reborncore.common.RebornCoreConfig;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.blocks.PropertyString;
import reborncore.common.items.WrenchHelper;
import reborncore.common.multiblock.BlockMultiblockBase;
import reborncore.common.util.ArrayUtils;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileMachineCasing;
import techreborn.utils.TechRebornCreativeTab;

public class BlockMachineCasing
extends BlockMultiblockBase {
    public static final String[] types = new String[]{"standard", "reinforced", "advanced"};
    public static final PropertyString TYPE = new PropertyString("type", types);
    private static final List<String> typesList = Lists.newArrayList((Object[])ArrayUtils.arrayToLowercase((String[])types));

    public BlockMachineCasing() {
        super(Material.IRON);
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setHardness(2.0f);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)TYPE, (Comparable)((Object)"standard")));
        for (int i = 0; i < types.length; ++i) {
            ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, i, "machines/structure", new IProperty[0]).setInvVariant("type=" + types[i]));
        }
        BlockWrenchEventHandler.wrenableBlocks.add(this);
    }

    public static ItemStack getStackByName(String name, int count) {
        name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            return new ItemStack(ModBlocks.MACHINE_CASINGS, count, i);
        }
        throw new InvalidParameterException("The machine casing " + name + " could not be found.");
    }

    public static ItemStack getStackByName(String name) {
        return BlockMachineCasing.getStackByName(name, 1);
    }

    public int getHeatFromState(IBlockState state) {
        switch (this.getMetaFromState(state)) {
            case 0: {
                return 40;
            }
            case 1: {
                return 68;
            }
            case 2: {
                return 95;
            }
        }
        return 0;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (RebornCoreConfig.wrenchRequired) {
            if (state.getValue((IProperty)TYPE) == "reinforced") {
                drops.add((Object)new ItemStack(ModBlocks.MACHINE_FRAMES, 1, 1));
            } else if (state.getValue((IProperty)TYPE) == "advanced") {
                drops.add((Object)new ItemStack(ModBlocks.MACHINE_FRAMES, 1, 2));
            } else {
                drops.add((Object)new ItemStack(ModBlocks.MACHINE_FRAMES, 1, 0));
            }
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.getHeldItem(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.getTileEntity(pos);
        if (tileEntity == null) {
            return false;
        }
        if (!stack.isEmpty() && ToolManager.INSTANCE.canHandleTool(stack) && WrenchHelper.handleWrench((ItemStack)stack, (World)worldIn, (BlockPos)pos, (EntityPlayer)playerIn, (EnumFacing)side)) {
            return true;
        }
        return super.onBlockActivated(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public IBlockState getStateFromMeta(int meta) {
        if (meta > types.length) {
            meta = 0;
        }
        return this.getBlockState().getBaseState().withProperty((IProperty)TYPE, (Comparable)((Object)typesList.get(meta)));
    }

    public int getMetaFromState(IBlockState state) {
        return typesList.indexOf(state.getValue((IProperty)TYPE));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Item.getItemFromBlock((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileMachineCasing();
    }
}

