/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.common.BaseBlock;
import techreborn.entities.EntityNukePrimed;
import techreborn.utils.TechRebornCreativeTab;

public class BlockNuke
extends BaseBlock {
    public static final PropertyBool OVERLAY = PropertyBool.create((String)"overlay");

    public BlockNuke() {
        super(Material.TNT);
        this.setUnlocalizedName("techreborn.nuke");
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)OVERLAY, (Comparable)Boolean.valueOf(false)));
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, new IProperty[0]));
    }

    public void ignite(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase igniter) {
        if (!worldIn.isRemote) {
            EntityNukePrimed entitynukeprimed = new EntityNukePrimed(worldIn, (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, igniter);
            worldIn.spawnEntity((Entity)entitynukeprimed);
            worldIn.playSound((EntityPlayer)null, entitynukeprimed.posX, entitynukeprimed.posY, entitynukeprimed.posZ, SoundEvents.ENTITY_TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void onBlockDestroyedByExplosion(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.isRemote) {
            EntityNukePrimed entitynukeprimed = new EntityNukePrimed(worldIn, (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, explosionIn.getExplosivePlacedBy());
            entitynukeprimed.setFuse(worldIn.rand.nextInt(EntityNukePrimed.fuseTime / 4) + EntityNukePrimed.fuseTime / 8);
            worldIn.spawnEntity((Entity)entitynukeprimed);
        }
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!worldIn.isRemote && entityIn instanceof EntityArrow) {
            EntityArrow entityarrow = (EntityArrow)entityIn;
            EntityLivingBase shooter = null;
            if (entityarrow.shootingEntity instanceof EntityLivingBase) {
                shooter = (EntityLivingBase)entityarrow.shootingEntity;
            }
            if (entityarrow.isBurning()) {
                this.ignite(worldIn, pos, state, shooter);
                worldIn.setBlockToAir(pos);
            }
        }
    }

    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state) {
        super.onBlockAdded(worldIn, pos, state);
        if (worldIn.isBlockPowered(pos)) {
            this.ignite(worldIn, pos, state, null);
            worldIn.setBlockToAir(pos);
        }
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
        if (worldIn.isBlockPowered(pos)) {
            this.ignite(worldIn, pos, state, null);
            worldIn.setBlockToAir(pos);
        }
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public int getMetaFromState(IBlockState state) {
        return (Boolean)state.getValue((IProperty)OVERLAY) != false ? 1 : 0;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)OVERLAY, (Comparable)Boolean.valueOf((meta & 1) > 0));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{OVERLAY});
    }
}

