/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.WorldUtils;
import techreborn.events.TRRecipeHandler;
import techreborn.init.ModSounds;
import techreborn.items.ingredients.ItemParts;
import techreborn.items.tools.ItemElectricTreetap;
import techreborn.items.tools.ItemTreeTap;
import techreborn.utils.TechRebornCreativeTab;

public class BlockRubberLog
extends Block {
    public static PropertyDirection SAP_SIDE = PropertyDirection.create((String)"sapside", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static PropertyBool HAS_SAP = PropertyBool.create((String)"hassap");

    public BlockRubberLog() {
        super(Material.WOOD);
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setHardness(2.0f);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)SAP_SIDE, (Comparable)EnumFacing.NORTH).withProperty((IProperty)HAS_SAP, (Comparable)Boolean.valueOf(false)));
        this.setTickRandomly(true);
        this.setSoundType(SoundType.WOOD);
        Blocks.FIRE.setFireInfo((Block)this, 5, 5);
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, new IProperty[0]));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{SAP_SIDE, HAS_SAP});
    }

    public IBlockState getStateFromMeta(int meta) {
        boolean hasSap = false;
        int tempMeta = meta;
        if (meta > 3) {
            hasSap = true;
            tempMeta -= 3;
        }
        EnumFacing facing = EnumFacing.getHorizontal((int)tempMeta);
        return this.getDefaultState().withProperty((IProperty)SAP_SIDE, (Comparable)facing).withProperty((IProperty)HAS_SAP, (Comparable)Boolean.valueOf(hasSap));
    }

    public int getMetaFromState(IBlockState state) {
        int tempMeta = 0;
        EnumFacing facing = (EnumFacing)state.getValue((IProperty)SAP_SIDE);
        switch (facing) {
            case SOUTH: {
                tempMeta = 0;
                break;
            }
            case WEST: {
                tempMeta = 1;
                break;
            }
            case NORTH: {
                tempMeta = 2;
                break;
            }
            case EAST: {
                tempMeta = 3;
                break;
            }
            case UP: {
                tempMeta = 0;
                break;
            }
            case DOWN: {
                tempMeta = 0;
            }
        }
        if (((Boolean)state.getValue((IProperty)HAS_SAP)).booleanValue()) {
            tempMeta += 4;
        }
        return tempMeta;
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        int i = 4;
        int j = i + 1;
        if (worldIn.isAreaLoaded(pos.add(-j, -j, -j), pos.add(j, j, j))) {
            for (BlockPos blockpos : BlockPos.getAllInBox((BlockPos)pos.add(-i, -i, -i), (BlockPos)pos.add(i, i, i))) {
                IBlockState state1 = worldIn.getBlockState(blockpos);
                if (!state1.getBlock().isLeaves(state1, (IBlockAccess)worldIn, blockpos)) continue;
                state1.getBlock().beginLeavesDecay(state1, worldIn, blockpos);
            }
        }
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.updateTick(worldIn, pos, state, rand);
        if (!((Boolean)state.getValue((IProperty)HAS_SAP)).booleanValue() && rand.nextInt(50) == 0) {
            EnumFacing facing = EnumFacing.getHorizontal((int)rand.nextInt(4));
            if (worldIn.getBlockState(pos.down()).getBlock() == this && worldIn.getBlockState(pos.up()).getBlock() == this) {
                worldIn.setBlockState(pos, state.withProperty((IProperty)HAS_SAP, (Comparable)Boolean.valueOf(true)).withProperty((IProperty)SAP_SIDE, (Comparable)facing));
            }
        }
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        super.onBlockActivated(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
        ItemStack stack = playerIn.getHeldItem(EnumHand.MAIN_HAND);
        if (stack.isEmpty()) {
            return false;
        }
        ForgePowerItemManager capEnergy = null;
        if (stack.getItem() instanceof ItemElectricTreetap) {
            capEnergy = new ForgePowerItemManager(stack);
        }
        if ((capEnergy != null && capEnergy.getEnergyStored() > 20 || stack.getItem() instanceof ItemTreeTap) && ((Boolean)state.getValue((IProperty)HAS_SAP)).booleanValue() && state.getValue((IProperty)SAP_SIDE) == side) {
            worldIn.setBlockState(pos, state.withProperty((IProperty)HAS_SAP, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)SAP_SIDE, (Comparable)EnumFacing.getHorizontal((int)0)));
            worldIn.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSounds.SAP_EXTRACT, SoundCategory.BLOCKS, 0.6f, 1.0f);
            if (!worldIn.isRemote) {
                if (capEnergy != null) {
                    capEnergy.extractEnergy(20, false);
                    ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)playerIn);
                } else {
                    playerIn.getHeldItem(EnumHand.MAIN_HAND).damageItem(1, (EntityLivingBase)playerIn);
                }
                if (!playerIn.inventory.addItemStackToInventory(ItemParts.getPartByName("rubberSap").copy())) {
                    WorldUtils.dropItem((ItemStack)ItemParts.getPartByName("rubberSap").copy(), (World)worldIn, (BlockPos)pos.offset(side));
                }
                if (playerIn instanceof EntityPlayerMP) {
                    TRRecipeHandler.unlockTRRecipes((EntityPlayerMP)playerIn);
                }
            }
            return true;
        }
        return false;
    }

    public int damageDropped(IBlockState state) {
        return 0;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((Block)this));
        if (((Boolean)state.getValue((IProperty)HAS_SAP)).booleanValue() && new Random().nextInt(4) == 0) {
            drops.add(ItemParts.getPartByName("rubberSap"));
        }
        return drops;
    }
}

