/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import techreborn.utils.TechRebornCreativeTab;

public abstract class BlockRubberPlankSlab
extends BlockSlab {
    public static final PropertyEnum<Variant> VARIANT = PropertyEnum.create((String)"variant", Variant.class);
    public final String name;
    public Block halfslab;

    public BlockRubberPlankSlab(String name) {
        super(Material.WOOD, Material.WOOD.getMaterialMapColor());
        this.name = name;
        IBlockState iblockstate = this.blockState.getBaseState();
        if (!this.isDouble()) {
            iblockstate = iblockstate.withProperty((IProperty)HALF, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
            this.halfslab = this;
        }
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setHarvestLevel("axe", 0);
        this.setHardness(2.0f);
        this.setResistance(15.0f);
        this.setSoundType(SoundType.WOOD);
        this.setDefaultState(iblockstate.withProperty(VARIANT, (Comparable)((Object)Variant.DEFAULT)));
        this.useNeighborBrightness = true;
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, new IProperty[0]));
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Item.getItemFromBlock((Block)this.halfslab);
    }

    public ItemStack getItem(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.halfslab);
    }

    public IBlockState getStateFromMeta(int meta) {
        IBlockState iblockstate = this.getDefaultState().withProperty(VARIANT, (Comparable)((Object)Variant.DEFAULT));
        if (!this.isDouble()) {
            iblockstate = iblockstate.withProperty((IProperty)HALF, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    public int getMetaFromState(IBlockState state) {
        int i = 0;
        if (!this.isDouble() && state.getValue((IProperty)HALF) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer createBlockState() {
        return this.isDouble() ? new BlockStateContainer((Block)this, new IProperty[]{VARIANT}) : new BlockStateContainer((Block)this, new IProperty[]{HALF, VARIANT});
    }

    public String getUnlocalizedName(int meta) {
        return super.getUnlocalizedName();
    }

    public IProperty<?> getVariantProperty() {
        return VARIANT;
    }

    public Comparable<?> getTypeForItem(ItemStack stack) {
        return Variant.DEFAULT;
    }

    public static class BlockHalf
    extends BlockRubberPlankSlab {
        public BlockHalf(String name) {
            super(name);
        }

        public boolean isDouble() {
            return false;
        }
    }

    public static class BlockDouble
    extends BlockRubberPlankSlab {
        public BlockDouble(String name, Block half) {
            super(name);
            this.halfslab = half;
        }

        public boolean isDouble() {
            return true;
        }
    }

    public static enum Variant implements IStringSerializable
    {
        DEFAULT;


        public String getName() {
            return "default";
        }
    }
}

