/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.TerrainGen;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import techreborn.utils.TechRebornCreativeTab;
import techreborn.world.RubberTreeGenerator;

public class BlockRubberSapling
extends BlockSapling {
    public BlockRubberSapling() {
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.setSoundType(SoundType.PLANT);
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, new IProperty[0]));
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        worldIn.setBlockToAir(pos);
        if (!new RubberTreeGenerator(false).growTree(worldIn, rand, pos.getX(), pos.getY(), pos.getZ())) {
            worldIn.setBlockState(pos, state);
        }
    }

    public void getSubBlocks(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
    }
}

