/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.common.BaseBlock;
import reborncore.common.blocks.PropertyString;
import reborncore.common.util.ArrayUtils;
import techreborn.blocks.BlockStorage2;
import techreborn.events.TRRecipeHandler;
import techreborn.init.ModBlocks;
import techreborn.utils.TechRebornCreativeTab;

public class BlockStorage
extends BaseBlock {
    public static final String[] types = new String[]{"silver", "aluminum", "titanium", "chrome", "steel", "brass", "lead", "electrum", "zinc", "platinum", "tungsten", "nickel", "invar", "iridium", "bronze"};
    public static final PropertyString TYPE = new PropertyString("type", types);
    private static final List<String> typesList = Lists.newArrayList((Object[])ArrayUtils.arrayToLowercase((String[])types));

    public BlockStorage() {
        super(Material.IRON);
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setHardness(2.0f);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)TYPE, (Comparable)((Object)"silver")));
        for (int i = 0; i < types.length; ++i) {
            ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, i, new IProperty[0]).setInvVariant("type=" + types[i]).setFileName("storage"));
        }
        TRRecipeHandler.hideEntry(this);
    }

    public static ItemStack getStorageBlockByName(String name, int count) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(name)) continue;
            return new ItemStack(ModBlocks.STORAGE, count, i);
        }
        return BlockStorage2.getStorageBlockByName(name, count);
    }

    public static ItemStack getStorageBlockByName(String name) {
        return BlockStorage.getStorageBlockByName(name, 1);
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Item.getItemFromBlock((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    public IBlockState getStateFromMeta(int meta) {
        if (meta > types.length) {
            meta = 0;
        }
        return this.getBlockState().getBaseState().withProperty((IProperty)TYPE, (Comparable)((Object)typesList.get(meta)));
    }

    public int getMetaFromState(IBlockState state) {
        return typesList.indexOf(state.getValue((IProperty)TYPE));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }
}

