/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.cable;

import java.security.InvalidParameterException;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.energy.CapabilityEnergy;
import reborncore.api.ToolManager;
import reborncore.common.RebornCoreConfig;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.items.WrenchHelper;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.blocks.cable.EnumCableType;
import techreborn.init.ModBlocks;
import techreborn.init.ModSounds;
import techreborn.tiles.cable.TileCable;
import techreborn.utils.TechRebornCreativeTab;
import techreborn.utils.damageSources.ElectrialShockSource;

@RebornRegistry(modID="techreborn")
public class BlockCable
extends BlockContainer {
    public static final PropertyBool EAST = PropertyBool.create((String)"east");
    public static final PropertyBool WEST = PropertyBool.create((String)"west");
    public static final PropertyBool NORTH = PropertyBool.create((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.create((String)"south");
    public static final PropertyBool UP = PropertyBool.create((String)"up");
    public static final PropertyBool DOWN = PropertyBool.create((String)"down");
    public static final IProperty<EnumCableType> TYPE = PropertyEnum.create((String)"type", EnumCableType.class);
    @ConfigRegistry(config="misc", category="cable", key="uninsulatedElectrocutionDamage", comment="When true an uninsulated cable will cause damage to entities")
    public static boolean uninsulatedElectrocutionDamage = true;
    @ConfigRegistry(config="misc", category="cable", key="uninsulatedElectrocutionSound", comment="When true an uninsulated cable will create a spark sound when an entity touches it")
    public static boolean uninsulatedElectrocutionSound = true;
    @ConfigRegistry(config="misc", category="cable", key="uninsulatedElectrocutionParticles", comment="When true an uninsulated cable will create a spark when an entity touches it")
    public static boolean uninsulatedElectrocutionParticles = true;

    public BlockCable() {
        super(Material.ROCK);
        this.setHardness(1.0f);
        this.setResistance(8.0f);
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)EAST, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)WEST, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)UP, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).withProperty(TYPE, (Comparable)((Object)EnumCableType.COPPER)));
        BlockWrenchEventHandler.wrenableBlocks.add(this);
    }

    public static ItemStack getCableByName(String name, int count) {
        for (int i = 0; i < EnumCableType.values().length; ++i) {
            if (!EnumCableType.values()[i].getName().equalsIgnoreCase(name)) continue;
            return new ItemStack(ModBlocks.CABLE, count, i);
        }
        throw new InvalidParameterException("The cable " + name + " could not be found.");
    }

    public static ItemStack getCableByName(String name) {
        return BlockCable.getCableByName(name, 1);
    }

    public TileEntity getTileEntitySafely(IBlockAccess blockAccess, BlockPos pos) {
        if (blockAccess instanceof ChunkCache) {
            return ((ChunkCache)blockAccess).getTileEntity(pos, Chunk.EnumCreateEntityType.CHECK);
        }
        return blockAccess.getTileEntity(pos);
    }

    public IProperty<Boolean> getProperty(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
        }
        return EAST;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileCable((EnumCableType)((Object)this.getStateFromMeta(meta).getValue(TYPE)));
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.getHeldItem(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.getTileEntity(pos);
        if (tileEntity == null) {
            return false;
        }
        if (!stack.isEmpty() && ToolManager.INSTANCE.canHandleTool(stack) && WrenchHelper.handleWrench((ItemStack)stack, (World)worldIn, (BlockPos)pos, (EntityPlayer)playerIn, (EnumFacing)side)) {
            return true;
        }
        return super.onBlockActivated(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (RebornCoreConfig.wrenchRequired) {
            if (state.getValue(TYPE) == EnumCableType.ICOPPER) {
                drops.add((Object)BlockCable.getCableByName("copper", 1));
            } else if (state.getValue(TYPE) == EnumCableType.IGOLD) {
                drops.add((Object)BlockCable.getCableByName("gold", 1));
            } else if (state.getValue(TYPE) == EnumCableType.IHV) {
                drops.add((Object)BlockCable.getCableByName("hv", 1));
            } else {
                super.getDrops(drops, world, pos, state, fortune);
            }
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ((EnumCableType)((Object)state.getValue(TYPE))).getStack();
    }

    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.getValue(TYPE) != EnumCableType.GLASSFIBER;
    }

    public boolean isFullBlock(IBlockState state) {
        return false;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{EAST, WEST, NORTH, SOUTH, UP, DOWN, TYPE});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getStateFromMeta(meta);
    }

    public void getSubBlocks(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumCableType cableType : EnumCableType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, cableType.ordinal()));
        }
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumCableType)((Object)state.getValue(TYPE))).ordinal();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)EnumCableType.values()[meta]));
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.getActualState(source, pos);
        float minSize = 0.3125f;
        float maxSize = 0.6875f;
        int thinkness = (int)((EnumCableType)((Object)state.getValue(BlockCable.TYPE))).cableThickness;
        if (thinkness == 6) {
            minSize = 0.35f;
            maxSize = 0.65f;
        }
        float minX = (Boolean)state.getValue((IProperty)WEST) != false ? 0.0f : minSize;
        float minY = (Boolean)state.getValue((IProperty)DOWN) != false ? 0.0f : minSize;
        float minZ = (Boolean)state.getValue((IProperty)NORTH) != false ? 0.0f : minSize;
        float maxX = (Boolean)state.getValue((IProperty)EAST) != false ? 1.0f : maxSize;
        float maxY = (Boolean)state.getValue((IProperty)UP) != false ? 1.0f : maxSize;
        float maxZ = (Boolean)state.getValue((IProperty)SOUTH) != false ? 1.0f : maxSize;
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState actualState = state;
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity tileEntity = this.getTileEntitySafely(worldIn, pos.offset(facing));
            if (tileEntity == null) continue;
            actualState = actualState.withProperty(this.getProperty(facing), (Comparable)Boolean.valueOf(tileEntity.hasCapability(CapabilityEnergy.ENERGY, facing.getOpposite())));
        }
        return actualState;
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity tileEntity;
        super.onEntityCollidedWithBlock(worldIn, pos, state, entity);
        if (((EnumCableType)((Object)state.getValue(BlockCable.TYPE))).canKill && entity instanceof EntityLivingBase && (tileEntity = worldIn.getTileEntity(pos)) != null && tileEntity instanceof TileCable) {
            TileCable tileCable = (TileCable)tileEntity;
            if (tileCable.power != 0) {
                if (uninsulatedElectrocutionDamage) {
                    if (state.getValue(TYPE) == EnumCableType.HV) {
                        entity.setFire(1);
                    }
                    entity.attackEntityFrom((DamageSource)new ElectrialShockSource(), 1.0f);
                }
                if (uninsulatedElectrocutionSound) {
                    worldIn.playSound(null, entity.posX, entity.posY, entity.posZ, ModSounds.CABLE_SHOCK, SoundCategory.BLOCKS, 0.6f, 1.0f);
                }
                if (uninsulatedElectrocutionParticles) {
                    worldIn.spawnParticle(EnumParticleTypes.CRIT, entity.posX, entity.posY, entity.posZ, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }
}

