/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.generator;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.ToolManager;
import reborncore.common.BaseTileBlock;
import reborncore.common.RebornCoreConfig;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.items.WrenchHelper;
import techreborn.init.ModBlocks;
import techreborn.tiles.generator.TileCreativeSolarPanel;
import techreborn.utils.TechRebornCreativeTab;

public class BlockCreativeSolarPanel
extends BaseTileBlock {
    public BlockCreativeSolarPanel() {
        super(Material.IRON);
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setHardness(2.0f);
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, "machines/generators", new IProperty[0]));
        BlockWrenchEventHandler.wrenableBlocks.add(this);
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.getHeldItem(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.getTileEntity(pos);
        if (tileEntity == null) {
            return false;
        }
        if (!stack.isEmpty() && ToolManager.INSTANCE.canHandleTool(stack) && WrenchHelper.handleWrench((ItemStack)stack, (World)worldIn, (BlockPos)pos, (EntityPlayer)playerIn, (EnumFacing)side)) {
            return true;
        }
        return super.onBlockActivated(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (RebornCoreConfig.wrenchRequired) {
            drops.add((Object)new ItemStack(ModBlocks.MACHINE_FRAMES, 1, 1));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileCreativeSolarPanel();
    }
}

