/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.generator.solarpanel;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.tile.IMachineGuiHandler;
import reborncore.common.blocks.BlockMachineBase;
import techreborn.blocks.generator.solarpanel.EnumPanelType;
import techreborn.tiles.generator.TileSolarPanel;
import techreborn.utils.TechRebornCreativeTab;

public class BlockSolarPanel
extends BlockMachineBase {
    public static final String[] panes = new String[]{"basic", "hybrid", "advanced", "ultimate", "quantum"};
    public static PropertyBool ACTIVE = PropertyBool.create((String)"active");
    public static final IProperty<EnumPanelType> TYPE = PropertyEnum.create((String)"type", EnumPanelType.class);

    public BlockSolarPanel() {
        super(true);
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).withProperty(TYPE, (Comparable)((Object)EnumPanelType.Basic)));
        for (int i = 0; i < panes.length; ++i) {
            ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, i, "machines/generators", new IProperty[0]).setInvVariant("active=false,type=" + panes[i]));
        }
    }

    public int getMetaFromState(IBlockState state) {
        int active = (Boolean)state.getValue((IProperty)ACTIVE) != false ? EnumPanelType.values().length : 0;
        return ((EnumPanelType)((Object)state.getValue(TYPE))).ordinal() + active;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, TYPE});
    }

    public IBlockState getStateFromMeta(int meta) {
        boolean active = false;
        if (meta >= EnumPanelType.values().length) {
            active = true;
            meta -= EnumPanelType.values().length;
        }
        return this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active)).withProperty(TYPE, (Comparable)((Object)EnumPanelType.values()[meta]));
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileSolarPanel((EnumPanelType)((Object)this.getStateFromMeta(meta).getValue(TYPE)));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getStateFromMeta(placer.getHeldItem(hand).getItemDamage());
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.getItemFromBlock((Block)this), 1, ((EnumPanelType)((Object)world.getBlockState(pos).getValue(TYPE))).ordinal());
    }

    public int damageDropped(IBlockState state) {
        return ((EnumPanelType)((Object)state.getValue(TYPE))).ordinal();
    }

    public void getSubBlocks(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumPanelType panelType : EnumPanelType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, panelType.ordinal()));
        }
    }

    public IMachineGuiHandler getGui() {
        return null;
    }
}

