/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.lighting;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.ToolManager;
import reborncore.common.BaseTileBlock;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.items.WrenchHelper;
import techreborn.tiles.lighting.TileLamp;
import techreborn.utils.TechRebornCreativeTab;

public class BlockLamp
extends BaseTileBlock {
    public static PropertyDirection FACING;
    public static PropertyBool ACTIVE;
    private AxisAlignedBB[] bbs;
    private int cost;
    private int brightness;

    public BlockLamp(int brightness, int cost, double depth, double width) {
        super(Material.REDSTONE_LIGHT);
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.bbs = BlockLamp.GenBoundingBoxes(depth, width);
        this.cost = cost;
        this.brightness = brightness;
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, "machines/lighting", new IProperty[0]));
        BlockWrenchEventHandler.wrenableBlocks.add(this);
    }

    private static AxisAlignedBB[] GenBoundingBoxes(double depth, double width) {
        AxisAlignedBB[] bb = new AxisAlignedBB[]{new AxisAlignedBB(width, 1.0 - depth, width, 1.0 - width, 1.0, 1.0 - width), new AxisAlignedBB(width, 0.0, width, 1.0 - width, depth, 1.0 - width), new AxisAlignedBB(width, width, 1.0 - depth, 1.0 - width, 1.0 - width, 1.0), new AxisAlignedBB(width, width, 0.0, 1.0 - width, 1.0 - width, depth), new AxisAlignedBB(1.0 - depth, width, width, 1.0, 1.0 - width, 1.0 - width), new AxisAlignedBB(0.0, width, width, depth, 1.0 - width, 1.0 - width)};
        return bb;
    }

    public static boolean isActive(IBlockState state) {
        return (Boolean)state.getValue((IProperty)ACTIVE);
    }

    public static EnumFacing getFacing(IBlockState state) {
        if (!state.getProperties().containsKey((Object)FACING)) {
            return EnumFacing.NORTH;
        }
        return (EnumFacing)state.getValue((IProperty)FACING);
    }

    public static void setFacing(EnumFacing facing, World world, BlockPos pos) {
        world.setBlockState(pos, world.getBlockState(pos).withProperty((IProperty)FACING, (Comparable)facing));
    }

    public static void setActive(Boolean active, World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)world.getBlockState(pos).getValue((IProperty)FACING);
        IBlockState state = world.getBlockState(pos).withProperty((IProperty)ACTIVE, (Comparable)active).withProperty((IProperty)FACING, (Comparable)facing);
        world.setBlockState(pos, state, 3);
    }

    public int getCost() {
        return this.cost;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileLamp();
    }

    protected BlockStateContainer createBlockState() {
        FACING = PropertyDirection.create((String)"facing");
        ACTIVE = PropertyBool.create((String)"active");
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)facing);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.getValue((IProperty)ACTIVE) != false ? this.brightness : 0;
    }

    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullBlock(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing facing) {
        if (BlockLamp.getFacing(state).getOpposite() == facing) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.bbs[BlockLamp.getFacing(state).getIndex()];
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.getHeldItem(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.getTileEntity(pos);
        if (tileEntity == null) {
            return false;
        }
        if (!stack.isEmpty() && ToolManager.INSTANCE.canHandleTool(stack) && WrenchHelper.handleWrench((ItemStack)stack, (World)worldIn, (BlockPos)pos, (EntityPlayer)playerIn, (EnumFacing)side)) {
            return true;
        }
        return super.onBlockActivated(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public int getMetaFromState(IBlockState state) {
        int facingInt = ((EnumFacing)state.getValue((IProperty)FACING)).getIndex();
        int activeInt = (Boolean)state.getValue((IProperty)ACTIVE) != false ? 8 : 0;
        return facingInt + activeInt;
    }

    public IBlockState getStateFromMeta(int meta) {
        Boolean active = (meta & 8) == 8;
        EnumFacing facing = EnumFacing.getFront((int)(meta & 7));
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)facing).withProperty((IProperty)ACTIVE, (Comparable)active);
    }
}

