/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.storage;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.ToolManager;
import reborncore.common.BaseTileBlock;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.items.WrenchHelper;
import techreborn.Core;
import techreborn.utils.TechRebornCreativeTab;

public abstract class BlockEnergyStorage
extends BaseTileBlock {
    public static PropertyDirection FACING = PropertyDirection.create((String)"facing", (Predicate)Facings.ALL);
    public String name;
    public int guiID;

    public BlockEnergyStorage(String name, int guiID) {
        super(Material.IRON);
        this.setHardness(2.0f);
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.name = name;
        this.guiID = guiID;
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, "machines/energy", new IProperty[0]));
        BlockWrenchEventHandler.wrenableBlocks.add(this);
    }

    public void setFacing(EnumFacing facing, World world, BlockPos pos) {
        world.setBlockState(pos, world.getBlockState(pos).withProperty((IProperty)FACING, (Comparable)facing));
    }

    public EnumFacing getSideFromint(int i) {
        if (i == 0) {
            return EnumFacing.NORTH;
        }
        if (i == 1) {
            return EnumFacing.SOUTH;
        }
        if (i == 2) {
            return EnumFacing.EAST;
        }
        if (i == 3) {
            return EnumFacing.WEST;
        }
        if (i == 4) {
            return EnumFacing.UP;
        }
        if (i == 5) {
            return EnumFacing.DOWN;
        }
        return EnumFacing.NORTH;
    }

    public int getSideFromEnum(EnumFacing facing) {
        if (facing == EnumFacing.NORTH) {
            return 0;
        }
        if (facing == EnumFacing.SOUTH) {
            return 1;
        }
        if (facing == EnumFacing.EAST) {
            return 2;
        }
        if (facing == EnumFacing.WEST) {
            return 3;
        }
        if (facing == EnumFacing.UP) {
            return 4;
        }
        if (facing == EnumFacing.DOWN) {
            return 5;
        }
        return 0;
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.getValue((IProperty)FACING);
    }

    public String getSimpleName(String fullName) {
        if (fullName.equalsIgnoreCase("Batbox")) {
            return "lv_storage";
        }
        if (fullName.equalsIgnoreCase("MEDIUM_VOLTAGE_SU")) {
            return "mv_storage";
        }
        if (fullName.equalsIgnoreCase("HIGH_VOLTAGE_SU")) {
            return "hv_storage";
        }
        if (fullName.equalsIgnoreCase("AESU")) {
            return "ev_storage_adjust";
        }
        if (fullName.equalsIgnoreCase("IDSU")) {
            return "ev_storage_transmitter";
        }
        if (fullName.equalsIgnoreCase("LESU")) {
            return "ev_multi";
        }
        return fullName.toLowerCase();
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BlockEnergyStorage) {
            EnumFacing facing = (EnumFacing)state.getValue((IProperty)FACING);
            facing = facing.getOpposite() == side ? side : side.getOpposite();
            world.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)facing));
            return true;
        }
        return false;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.getHeldItem(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.getTileEntity(pos);
        if (tileEntity == null) {
            return false;
        }
        if (!stack.isEmpty() && ToolManager.INSTANCE.canHandleTool(stack) && WrenchHelper.handleWrench((ItemStack)stack, (World)worldIn, (BlockPos)pos, (EntityPlayer)playerIn, (EnumFacing)side)) {
            return true;
        }
        if (!playerIn.isSneaking()) {
            playerIn.openGui((Object)Core.INSTANCE, this.guiID, worldIn, pos.getX(), pos.getY(), pos.getZ());
            return true;
        }
        return super.onBlockActivated(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    protected BlockStateContainer createBlockState() {
        FACING = PropertyDirection.create((String)"facing", (Predicate)Facings.ALL);
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack);
        EnumFacing facing = placer.getHorizontalFacing().getOpposite();
        if (placer.rotationPitch < -50.0f) {
            facing = EnumFacing.DOWN;
        } else if (placer.rotationPitch > 50.0f) {
            facing = EnumFacing.UP;
        }
        this.setFacing(facing, worldIn, pos);
    }

    public int getMetaFromState(IBlockState state) {
        int facingInt = this.getSideFromEnum((EnumFacing)state.getValue((IProperty)FACING));
        return facingInt;
    }

    public IBlockState getStateFromMeta(int meta) {
        EnumFacing facing = this.getSideFromint(meta);
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)facing);
    }

    public static enum Facings implements Predicate<EnumFacing>,
    Iterable<EnumFacing>
    {
        ALL;


        public EnumFacing[] facings() {
            return new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP, EnumFacing.DOWN};
        }

        public EnumFacing random(Random rand) {
            EnumFacing[] aenumfacing = this.facings();
            return aenumfacing[rand.nextInt(aenumfacing.length)];
        }

        public boolean apply(EnumFacing p_apply_1_) {
            return p_apply_1_ != null;
        }

        @Override
        public Iterator<EnumFacing> iterator() {
            return Iterators.forArray((Object[])this.facings());
        }
    }
}

